/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.lifecycle;

import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.el.ELContext;
import javax.faces.application.Application;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;

public class ViewScopePhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 4328185923344558170L;
    private static final Logger logger = LoggerFactory.getLogger(ViewScopePhaseListener.class);

    public void afterPhase(PhaseEvent phaseEvent) {
        FacesContext facesContext = phaseEvent.getFacesContext();
        if (facesContext.isPostback()) {
            this.processViewScopedManagedBeans(facesContext);
        }
    }

    public void beforePhase(PhaseEvent phaseEvent) {
    }

    public PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }

    protected Map<String, Field> getManagedPropertyFields(Class<?> managedBeanClass) {
        Field[] declaredFields;
        HashMap<String, Field> managedPropertyFields = new HashMap<String, Field>();
        for (Field declaredField : declaredFields = managedBeanClass.getDeclaredFields()) {
            ManagedProperty managedPropertyAnnotation = declaredField.getAnnotation(ManagedProperty.class);
            if (managedPropertyAnnotation == null) continue;
            String managedPropertyName = this.getManagedPropertyName(managedPropertyAnnotation, declaredField);
            managedPropertyFields.put(managedPropertyName, declaredField);
            Class<?> superClass = managedBeanClass.getSuperclass();
            if (Object.class.equals(superClass)) continue;
            Map<String, Field> superClassFields = this.getManagedPropertyFields(superClass);
            Set<Map.Entry<String, Field>> superClassFieldsEntrySet = superClassFields.entrySet();
            for (Map.Entry<String, Field> superClassMapEntry : superClassFieldsEntrySet) {
                String superClassManagedPropertyName = superClassMapEntry.getKey();
                if (managedPropertyFields.containsKey(superClassManagedPropertyName)) continue;
                Field superClassManagedPropertyField = superClassMapEntry.getValue();
                managedPropertyFields.put(superClassManagedPropertyName, superClassManagedPropertyField);
            }
        }
        return managedPropertyFields;
    }

    protected String getManagedPropertyName(ManagedProperty managedProperty, Field field) {
        String managedPropertyName = managedProperty.name();
        if (managedPropertyName == null || managedPropertyName.length() == 0) {
            managedPropertyName = field.getName();
        }
        return managedPropertyName;
    }

    protected void injectManagedProperties(Object managedBean, ManagedPropertyInjector managedPropertyInjector) {
        if (managedBean.getClass().isAnnotationPresent(ManagedBean.class)) {
            Map<String, Field> managedPropertyFields = this.getManagedPropertyFields(managedBean.getClass());
            Set<Map.Entry<String, Field>> managedPropertyEntrySet = managedPropertyFields.entrySet();
            for (Map.Entry<String, Field> managedPropertyMapEntry : managedPropertyEntrySet) {
                String managedPropertyName = managedPropertyMapEntry.getKey();
                Field managedPropertyField = managedPropertyMapEntry.getValue();
                ManagedProperty managedPropertyAnnotation = managedPropertyField.getAnnotation(ManagedProperty.class);
                String managedPropertyExpression = managedPropertyAnnotation.value();
                if (managedPropertyExpression == null || managedPropertyExpression.length() <= 0) continue;
                managedPropertyInjector.inject(managedBean, managedPropertyName, managedPropertyField.getType(), managedPropertyExpression);
            }
        }
    }

    protected void processViewScopedManagedBeans(FacesContext facesContext) {
        UIViewRoot viewRoot = facesContext.getViewRoot();
        if (viewRoot != null) {
            ManagedPropertyInjector managedPropertyInjector = new ManagedPropertyInjector(facesContext);
            Map viewMap = viewRoot.getViewMap();
            Set managedBeanEntrySet = viewMap.entrySet();
            for (Map.Entry managedBeanMapEntry : managedBeanEntrySet) {
                Object managedBean = managedBeanMapEntry.getValue();
                if (managedBean == null) continue;
                this.injectManagedProperties(managedBean, managedPropertyInjector);
            }
        }
    }

    private static final class ManagedPropertyInjector {
        private static final String EXPRESSION_PREFIX = "#{";
        private static final String EXPRESSION_SUFFIX = "}";
        private static final String METHOD_PREFIX_SET = "set";
        private Application application;
        private ELContext elContext;

        public ManagedPropertyInjector(FacesContext facesContext) {
            this.application = facesContext.getApplication();
            this.elContext = facesContext.getELContext();
        }

        public void inject(Object managedBean, String managedPropertyName, Class<?> managedPropertyClass, String elExpression) {
            String expressionWithoutSyntax = this.removeExpressionSyntax(elExpression);
            try {
                Object managedPropertyValue = this.application.getELResolver().getValue(this.elContext, null, (Object)expressionWithoutSyntax);
                String methodName = METHOD_PREFIX_SET + managedPropertyName.toUpperCase().substring(0, 1) + managedPropertyName.substring(1);
                Method setterMethod = managedBean.getClass().getMethod(methodName, managedPropertyClass);
                if (setterMethod != null) {
                    setterMethod.invoke(managedBean, managedPropertyValue);
                    logger.debug("Injected @ManagedProperty name=[{0}] elExpression=[{1}] value=[{2}] into @ViewScoped managedBean=[{3}]", managedPropertyName, elExpression, managedPropertyValue, managedBean);
                } else {
                    logger.error("Unable to inject managed-property name=[{0}] elExpression=[{1}] using setter methodName=[{2}]", managedPropertyName, elExpression, methodName);
                }
            }
            catch (Exception e) {
                logger.error(e);
            }
        }

        protected String removeExpressionSyntax(String elExpression) {
            String expressionWithoutSyntax = elExpression;
            if (expressionWithoutSyntax != null) {
                if (expressionWithoutSyntax.startsWith(EXPRESSION_PREFIX)) {
                    expressionWithoutSyntax = expressionWithoutSyntax.substring(EXPRESSION_PREFIX.length());
                }
                if (expressionWithoutSyntax.endsWith(EXPRESSION_SUFFIX)) {
                    expressionWithoutSyntax = expressionWithoutSyntax.substring(0, expressionWithoutSyntax.length() - EXPRESSION_SUFFIX.length());
                }
            }
            return expressionWithoutSyntax;
        }
    }
}

