/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.i18n.internal;

import com.liferay.faces.util.cache.Cache;
import com.liferay.faces.util.cache.CacheFactory;
import com.liferay.faces.util.config.WebConfigParam;
import com.liferay.faces.util.i18n.I18n;
import com.liferay.faces.util.i18n.I18nUtil;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.osgi.internal.ResourceBundleUtil;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

public class I18nImpl
implements I18n,
Serializable {
    private static final long serialVersionUID = 707385608167301726L;
    private static final Logger logger = LoggerFactory.getLogger(I18nImpl.class);

    public I18nImpl() {
        FacesContext startupFacesContext = FacesContext.getCurrentInstance();
        if (startupFacesContext != null) {
            ExternalContext externalContext = startupFacesContext.getExternalContext();
            int initialCacheCapacity = WebConfigParam.I18nInitialCacheCapacity.getIntegerValue(externalContext);
            int maxCacheCapacity = WebConfigParam.I18nMaxCacheCapacity.getIntegerValue(externalContext);
            Cache facesResourceBundleCache = maxCacheCapacity > -1 ? CacheFactory.getConcurrentLRUCacheInstance(externalContext, initialCacheCapacity, maxCacheCapacity) : CacheFactory.getConcurrentCacheInstance(externalContext, initialCacheCapacity);
            Map applicationMap = externalContext.getApplicationMap();
            applicationMap.put(I18nImpl.class.getName(), facesResourceBundleCache);
        } else {
            logger.error("Unable to store the resource bundle cache in the application map");
        }
    }

    @Override
    public FacesMessage getFacesMessage(FacesContext facesContext, Locale locale, FacesMessage.Severity severity, String messageId) {
        return I18nUtil.getFacesMessage(this, facesContext, locale, severity, messageId);
    }

    @Override
    public FacesMessage getFacesMessage(FacesContext facesContext, Locale locale, FacesMessage.Severity severity, String messageId, Object ... arguments) {
        return I18nUtil.getFacesMessage(this, facesContext, locale, severity, messageId, arguments);
    }

    @Override
    public String getMessage(FacesContext facesContext, Locale locale, String messageId) {
        return this.getMessage(facesContext, locale, messageId, new Object[0]);
    }

    @Override
    public String getMessage(FacesContext facesContext, Locale locale, String messageId, Object ... arguments) {
        ResourceBundle facesResourceBundle;
        String message = null;
        try {
            ResourceBundle resourceBundle = ResourceBundleUtil.getUTF8ResourceBundleInOSGiEnvironment("i18n", locale);
            message = resourceBundle.getString(messageId);
        }
        catch (MissingResourceException resourceBundle) {
            // empty catch block
        }
        if (message == null && (facesResourceBundle = this.getFacesResourceBundle(facesContext, locale)) != null) {
            try {
                message = facesResourceBundle.getString(messageId);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (message == null) {
            message = messageId;
        } else if (arguments != null && arguments.length > 0) {
            message = MessageFormat.format(message, arguments);
        }
        return message;
    }

    private ResourceBundle getFacesResourceBundle(FacesContext facesContext, Locale locale) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Map applicationMap = externalContext.getApplicationMap();
        Cache facesResourceBundleCache = (Cache)applicationMap.get(I18nImpl.class.getName());
        ResourceBundle facesResourceBundle = null;
        if (facesResourceBundleCache != null) {
            facesResourceBundle = (ResourceBundle)facesResourceBundleCache.getValue(locale);
        }
        if (facesResourceBundle == null) {
            Application application = facesContext.getApplication();
            String messageBundle = application.getMessageBundle();
            if (messageBundle == null) {
                messageBundle = "javax.faces.Messages";
            }
            facesResourceBundle = ResourceBundleUtil.getUTF8ResourceBundleInOSGiEnvironment(messageBundle, locale);
            if (facesResourceBundleCache != null) {
                facesResourceBundle = facesResourceBundleCache.putValueIfAbsent(locale, facesResourceBundle);
            }
        }
        return facesResourceBundle;
    }
}

