/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.config.internal;

import com.liferay.faces.util.config.ConfiguredServlet;
import com.liferay.faces.util.config.ConfiguredServletMapping;
import com.liferay.faces.util.config.FacesConfig;
import com.liferay.faces.util.config.WebConfig;
import com.liferay.faces.util.config.internal.ConfiguredServletMappingImpl;
import com.liferay.faces.util.config.internal.FacesConfigDescriptor;
import com.liferay.faces.util.config.internal.FacesConfigDescriptorParser;
import com.liferay.faces.util.config.internal.FacesConfigDescriptorParserImpl;
import com.liferay.faces.util.config.internal.FacesConfigImpl;
import com.liferay.faces.util.config.internal.FacesConfigParser;
import com.liferay.faces.util.config.internal.FacesConfigParserImpl;
import com.liferay.faces.util.config.internal.FacesConfigScanner;
import com.liferay.faces.util.config.internal.OrderingUtil;
import com.liferay.faces.util.config.internal.ResourceReader;
import com.liferay.faces.util.internal.CloseableUtil;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.osgi.internal.FacesBundlesHandlerBase;
import com.liferay.faces.util.osgi.internal.FacesBundlesHandlerResourceProviderOSGiImpl;
import com.liferay.faces.util.product.internal.ProductMojarraImpl;
import com.liferay.faces.util.product.internal.ProductPlutoImpl;
import com.liferay.faces.util.resource.internal.ResourceProviderUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.webapp.FacesServlet;
import javax.xml.parsers.SAXParser;
import org.osgi.framework.Bundle;

public class FacesConfigScannerImpl
implements FacesConfigScanner {
    private static final Logger logger = LoggerFactory.getLogger(FacesConfigScannerImpl.class);
    private static final String FACES_CONFIG_META_INF_PATH = "/META-INF/faces-config.xml";
    private static final String FACES_CONFIG_WEB_INF_PATH = "/WEB-INF/faces-config.xml";
    private static final String FACES_SERVLET = "Faces Servlet";
    private static final String FACES_SERVLET_FQCN = FacesServlet.class.getName();
    private static final String MOJARRA_CONFIG_PATH = "/com/sun/faces/jsf-ri-runtime.xml";
    private ClassLoader classLoader;
    private boolean resolveEntities;
    private ResourceReader resourceReader;
    private SAXParser saxParser;
    private WebConfig webConfig;

    public FacesConfigScannerImpl(ClassLoader classLoader, ResourceReader resourceReader, SAXParser saxParser, boolean resolveEntities, WebConfig webConfig) {
        this.classLoader = classLoader;
        this.saxParser = saxParser;
        this.resourceReader = resourceReader;
        this.resolveEntities = resolveEntities;
        this.webConfig = webConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FacesConfig scan() throws IOException {
        String defaultSuffixParam;
        List<ConfiguredServletMapping> configuredServletMappings;
        String configuredFacesServletName = FACES_SERVLET;
        ArrayList<ConfiguredServletMapping> facesServletMappings = new ArrayList<ConfiguredServletMapping>();
        List<ConfiguredServlet> configuredServlets = this.webConfig.getConfiguredServlets();
        if (configuredServlets != null) {
            for (ConfiguredServlet configuredServlet : configuredServlets) {
                if (!FACES_SERVLET_FQCN.equals(configuredServlet.getServletClass())) continue;
                configuredFacesServletName = configuredServlet.getServletName();
                break;
            }
        }
        if ((configuredServletMappings = this.webConfig.getConfiguredServletMappings()) != null) {
            for (ConfiguredServletMapping configuredServletMapping : configuredServletMappings) {
                if (!configuredFacesServletName.equals(configuredServletMapping.getServletName())) continue;
                facesServletMappings.add(configuredServletMapping);
            }
        }
        if ((defaultSuffixParam = this.webConfig.getConfiguredContextParams().get("javax.faces.DEFAULT_SUFFIX")) == null) {
            defaultSuffixParam = ".xhtml .view.xml .jsp";
        }
        List<String> configuredSuffixes = Arrays.asList(defaultSuffixParam.split(" "));
        for (String configuredSuffix : configuredSuffixes) {
            boolean found = false;
            for (ConfiguredServletMapping explicitFacesServletMapping : facesServletMappings) {
                if (!explicitFacesServletMapping.isExtensionMapped() || !explicitFacesServletMapping.getExtension().equals(configuredSuffix)) continue;
                found = true;
                break;
            }
            if (found) continue;
            String urlPattern = "*" + configuredSuffix;
            ConfiguredServletMappingImpl implicitFacesServletMapping = new ConfiguredServletMappingImpl(FACES_SERVLET, urlPattern, true);
            facesServletMappings.add(implicitFacesServletMapping);
            logger.debug("Added implicit extension-mapped servlet-mapping for urlPattern=[{0}]", urlPattern);
        }
        FacesConfig facesConfig = new FacesConfigImpl(facesServletMappings, configuredSuffixes);
        InputStream inputStream = null;
        try {
            FacesConfigDescriptor mojarraConfigDescriptor = null;
            FacesConfigDescriptor webInfFacesConfigDescriptor = null;
            FacesConfigDescriptorParser facesConfigDescriptorParser = this.newFacesConfigDescriptorParser();
            FacesConfigParser facesConfigParser = this.newFacesConfigParser();
            List<URL> facesConfigURLs = this.getFacesConfigURLs(this.classLoader);
            ArrayList<FacesConfigDescriptor> facesConfigDescriptors = new ArrayList<FacesConfigDescriptor>();
            for (URL facesConfigURL : facesConfigURLs) {
                logger.debug("Pre-processing faces-config: [{0}]", facesConfigURL);
                inputStream = facesConfigURL.openStream();
                String facesConfigPath = facesConfigURL.getPath();
                if (facesConfigPath.endsWith(MOJARRA_CONFIG_PATH)) {
                    mojarraConfigDescriptor = facesConfigDescriptorParser.parse(inputStream, facesConfigURL);
                } else if (facesConfigPath.endsWith(FACES_CONFIG_WEB_INF_PATH)) {
                    webInfFacesConfigDescriptor = facesConfigDescriptorParser.parse(inputStream, facesConfigURL);
                } else {
                    FacesConfigDescriptor facesConfigDescriptor = facesConfigDescriptorParser.parse(inputStream, facesConfigURL);
                    facesConfigDescriptors.add(facesConfigDescriptor);
                }
                inputStream.close();
            }
            boolean MOJARRA_DETECTED = new ProductMojarraImpl().isDetected();
            if (MOJARRA_DETECTED && mojarraConfigDescriptor == null) {
                logger.warn("{0} not found./com/sun/faces/jsf-ri-runtime.xml");
            }
            List<FacesConfigDescriptor> orderedConfigs = OrderingUtil.getOrderedFacesConfigDescriptors(mojarraConfigDescriptor, facesConfigDescriptors, webInfFacesConfigDescriptor);
            for (FacesConfigDescriptor config : orderedConfigs) {
                String urlString = config.getURL();
                URL url = new URL(urlString);
                logger.debug("Post-processing faces-config: [{0}]", url);
                inputStream = url.openStream();
                try {
                    if (urlString.contains(MOJARRA_CONFIG_PATH)) {
                        FacesConfigParserImpl mojarraConfigParser = new FacesConfigParserImpl(this.saxParser, this.resolveEntities);
                        mojarraConfigParser.parse(inputStream, facesConfig);
                    } else {
                        facesConfig = facesConfigParser.parse(inputStream, facesConfig);
                    }
                }
                catch (IOException e) {
                    logger.error(e);
                }
                inputStream.close();
                try {
                    this.saxParser.reset();
                }
                catch (Exception e) {
                    logger.error(e);
                }
            }
            CloseableUtil.close(inputStream);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        finally {
            CloseableUtil.close(inputStream);
        }
        return facesConfig;
    }

    protected SAXParser getSAXParser() {
        return this.saxParser;
    }

    protected FacesConfigDescriptorParser newFacesConfigDescriptorParser() {
        return new FacesConfigDescriptorParserImpl(this.saxParser, this.resolveEntities);
    }

    protected FacesConfigParser newFacesConfigParser() {
        return new FacesConfigParserImpl(this.saxParser, this.resolveEntities);
    }

    private List<URL> getFacesConfigURLs(ClassLoader classLoader) throws IOException {
        ArrayList<URL> facesConfigURLs = new ArrayList<URL>();
        FacesContext initFacesContext = FacesContext.getCurrentInstance();
        if (FacesBundlesHandlerBase.isCurrentWarThinWab()) {
            FacesBundlesHandlerFacesConfigScannerImpl facesBundlesHandler = new FacesBundlesHandlerFacesConfigScannerImpl("/META-INF/", "*faces-config.xml");
            facesConfigURLs.addAll((Collection)facesBundlesHandler.handleFacesBundles(initFacesContext));
        } else {
            ProductPlutoImpl pluto = new ProductPlutoImpl();
            URL mojarraConfigURL = pluto.isDetected() ? classLoader.getResource(MOJARRA_CONFIG_PATH.substring(1)) : classLoader.getResource(MOJARRA_CONFIG_PATH);
            if (mojarraConfigURL != null) {
                facesConfigURLs.add(mojarraConfigURL);
            }
            Enumeration<URL> facesConfigResources = pluto.isDetected() ? classLoader.getResources(FACES_CONFIG_META_INF_PATH.substring(1)) : classLoader.getResources(FACES_CONFIG_META_INF_PATH);
            ResourceProviderUtil.addAllEnumerationURLsToList(facesConfigResources, facesConfigURLs);
            FacesBundlesHandlerResourceProviderOSGiImpl facesBundlesHandler = new FacesBundlesHandlerResourceProviderOSGiImpl("/META-INF/", "*.faces-config.xml");
            facesConfigURLs.addAll((Collection)facesBundlesHandler.handleFacesBundles(initFacesContext));
        }
        ExternalContext externalContext = initFacesContext.getExternalContext();
        URL webInfFacesConfigURL = externalContext.getResource(FACES_CONFIG_WEB_INF_PATH);
        if (webInfFacesConfigURL != null) {
            facesConfigURLs.add(webInfFacesConfigURL);
        }
        return Collections.unmodifiableList(facesConfigURLs);
    }

    private static final class FacesBundlesHandlerFacesConfigScannerImpl
    extends FacesBundlesHandlerResourceProviderOSGiImpl {
        public FacesBundlesHandlerFacesConfigScannerImpl(String path, String facesBundleFilePattern) {
            super(path, facesBundleFilePattern);
        }

        @Override
        protected void handleFacesBundle(Bundle bundle, FacesBundlesHandlerBase.ReturnValueReference<List<URL>> returnValueReference) {
            List<URL> resourceURLs = returnValueReference.get();
            URL mojarraConfigURL = bundle.getEntry(FacesConfigScannerImpl.MOJARRA_CONFIG_PATH);
            if (mojarraConfigURL != null) {
                resourceURLs.add(mojarraConfigURL);
            }
            super.handleFacesBundle(bundle, returnValueReference);
        }
    }
}

