/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.config.internal;

import com.liferay.faces.util.config.ConfiguredServletMapping;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;

public class ConfiguredServletMappingImpl
implements ConfiguredServletMapping {
    private static final Logger logger = LoggerFactory.getLogger(ConfiguredServletMappingImpl.class);
    private static final String EXTENSION_WILDCARD = "*.";
    private String extension;
    private boolean extensionMapped;
    private boolean implicit;
    private String path;
    private boolean pathMapped;
    private String servletName;
    private String urlPattern;

    public ConfiguredServletMappingImpl(String servletName, String urlPattern, boolean implicit) {
        this.servletName = servletName;
        this.urlPattern = urlPattern;
        this.implicit = implicit;
        if (urlPattern != null) {
            if (urlPattern.startsWith("/") && urlPattern.endsWith("*")) {
                this.pathMapped = true;
                this.path = urlPattern.substring(0, urlPattern.length() - "/".length() - "*".length());
            } else if (urlPattern.startsWith(EXTENSION_WILDCARD)) {
                this.extensionMapped = true;
                this.extension = urlPattern.substring("*".length());
            } else {
                this.pathMapped = true;
                this.path = urlPattern;
            }
        }
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public String getServletName() {
        return this.servletName;
    }

    @Override
    public String getServletPath() {
        return this.path;
    }

    @Override
    public String getUrlPattern() {
        return this.urlPattern;
    }

    @Override
    public boolean isExtensionMapped() {
        return this.extensionMapped;
    }

    @Override
    public boolean isImplicit() {
        return this.implicit;
    }

    @Override
    public boolean isMatch(String uri) {
        boolean match = false;
        if (uri != null) {
            if (this.extensionMapped) {
                match = uri.endsWith(this.extension);
                logger.trace("Testing match for servlet-mapping url-pattern=[{0}] EXTENSION=[{1}] uri=[{2}] match=[{3}]", this.urlPattern, this.extension, uri, match);
            } else if (this.pathMapped) {
                int pos = uri.lastIndexOf("/");
                String uriPath = uri;
                if (pos > 0) {
                    uriPath = uri.substring(0, pos);
                }
                match = this.path.contains(uriPath) || uriPath.startsWith(this.path);
                logger.trace("Testing match for servlet-mapping url-pattern=[{0}] PATH=[{1}] uri=[{2}] match=[{3}]", this.urlPattern, this.path, uri, match);
            }
        }
        return match;
    }

    @Override
    public boolean isPathMapped() {
        return this.pathMapped;
    }

    public String toString() {
        return "extension=" + this.extension + " extensionMapped=" + this.extensionMapped + " path=" + this.path + " pathMapped=" + this.pathMapped + " servletName=" + this.servletName + " urlPattern=" + this.urlPattern;
    }
}

