/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.component;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.html.HtmlOutputLabel;
import javax.faces.context.FacesContext;

public class ComponentUtil {
    private static final String DOUBLE_BACKSLASH_COLON = "\\\\\\\\:";
    private static final String REGEX_COLON = "[:]";

    public static String concatCssClasses(String ... classNames) {
        StringBuilder cssClassBuilder = new StringBuilder();
        boolean first = true;
        for (String className : classNames) {
            if (className == null) continue;
            if (!first) {
                cssClassBuilder.append(" ");
            }
            cssClassBuilder.append(className);
            first = false;
        }
        String allClasses = cssClassBuilder.toString();
        if (allClasses.length() == 0) {
            allClasses = null;
        }
        return allClasses;
    }

    public static String escapeClientId(String clientId) {
        String escapedClientId = clientId;
        if (escapedClientId != null) {
            escapedClientId = escapedClientId.replaceAll(REGEX_COLON, DOUBLE_BACKSLASH_COLON);
        }
        return escapedClientId;
    }

    public static String findClientId(String expression) {
        return ComponentUtil.findClientId(FacesContext.getCurrentInstance(), expression);
    }

    public static String findClientId(FacesContext facesContext, String expression) {
        String clientId = null;
        UIViewRoot uiViewRoot = facesContext.getViewRoot();
        UIComponent uiComponent = uiViewRoot.findComponent(expression);
        if (uiComponent == null) {
            uiComponent = ComponentUtil.matchComponentInHierarchy(facesContext, (UIComponent)uiViewRoot, expression);
        }
        if (uiComponent != null) {
            clientId = uiComponent.getClientId(facesContext);
        }
        return clientId;
    }

    public static String getComponentLabel(UIComponent uiComponent) {
        String componentLabel = null;
        if (uiComponent != null && (componentLabel = ComponentUtil.getParentFieldLabelValue(uiComponent)) == null) {
            componentLabel = ComponentUtil.getSiblingLabelValue(uiComponent);
        }
        return componentLabel;
    }

    public static UIComponent matchComponentInHierarchy(FacesContext facesContext, UIComponent parent, String partialClientId) {
        UIComponent uiComponent;
        block1: {
            UIComponent child;
            block2: {
                uiComponent = null;
                if (parent == null) break block1;
                String parentClientId = parent.getClientId(facesContext);
                if (parentClientId == null || parentClientId.indexOf(partialClientId) < 0) break block2;
                uiComponent = parent;
                break block1;
            }
            Iterator itr = parent.getFacetsAndChildren();
            if (itr == null) break block1;
            while (itr.hasNext() && (uiComponent = ComponentUtil.matchComponentInHierarchy(facesContext, child = (UIComponent)itr.next(), partialClientId)) == null) {
            }
        }
        return uiComponent;
    }

    private static String getParentFieldLabelValue(UIComponent uiComponent) {
        UIComponent parent;
        String parentFieldLabel = null;
        if (uiComponent != null && (parent = uiComponent.getParent()) != null) {
            Method method = null;
            try {
                method = parent.getClass().getMethod("getLabel", null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (method != null) {
                try {
                    parentFieldLabel = (String)method.invoke((Object)parent, (Object[])null);
                }
                catch (Exception exception) {}
            } else {
                parentFieldLabel = ComponentUtil.getParentFieldLabelValue(parent);
            }
        }
        return parentFieldLabel;
    }

    private static String getSiblingLabelValue(UIComponent uiComponent) {
        List children;
        UIComponent parent;
        String siblingLabelValue = null;
        if (uiComponent != null && (parent = uiComponent.getParent()) != null && (children = parent.getChildren()) != null) {
            for (UIComponent child : children) {
                Object labelValue;
                if (!(child instanceof HtmlOutputLabel)) continue;
                HtmlOutputLabel htmlOutputLabel = (HtmlOutputLabel)child;
                if (!uiComponent.getId().equals(htmlOutputLabel.getFor()) || (labelValue = htmlOutputLabel.getValue()) == null) continue;
                siblingLabelValue = labelValue.toString();
            }
        }
        return siblingLabelValue;
    }
}

