/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.cache.internal;

import com.liferay.faces.util.cache.Cache;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ConcurrentLRUCacheImpl<K, V>
implements Cache<K, V>,
Serializable {
    private static final long serialVersionUID = 6181106754606500765L;
    private final ConcurrentHashMap<K, CachedValue<V>> internalCache;
    private final Integer maxCapacity;

    public ConcurrentLRUCacheImpl(int initialCapacity, int maxCapacity) {
        this.internalCache = new ConcurrentHashMap(initialCapacity);
        this.maxCapacity = maxCapacity;
    }

    @Override
    public boolean containsKey(K key) {
        return this.internalCache.containsKey(key);
    }

    @Override
    public Set<K> getKeys() {
        return this.internalCache.keySet();
    }

    @Override
    public int getSize() {
        return this.internalCache.size();
    }

    @Override
    public V getValue(K key) {
        CachedValue<V> cachedValue = this.internalCache.get(key);
        if (cachedValue != null) {
            return cachedValue.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putValueIfAbsent(K key, V value) {
        CachedValue<V> cachedValue;
        ConcurrentLRUCacheImpl concurrentLRUCacheImpl = this;
        synchronized (concurrentLRUCacheImpl) {
            this.removeLeastRecentlyUsedCacheValueIfNecessary(key);
            cachedValue = this.internalCache.putIfAbsent(key, new CachedValue<V>(value));
        }
        V retValue = cachedValue != null ? cachedValue.getValue() : value;
        return retValue;
    }

    @Override
    public V removeValue(K key) {
        V value = null;
        CachedValue<V> cachedValue = this.internalCache.remove(key);
        if (cachedValue != null) {
            value = cachedValue.getValue();
        }
        return value;
    }

    private void removeLeastRecentlyUsedCacheValueIfNecessary(K key) {
        if (this.internalCache.size() >= this.maxCapacity && !this.internalCache.containsKey(key)) {
            Set<Map.Entry<K, CachedValue<V>>> entrySet = this.internalCache.entrySet();
            Map.Entry<K, CachedValue<CachedValue<V>>> leastRecentlyAccessedEntry = null;
            for (Map.Entry<K, CachedValue<CachedValue<V>>> entry : entrySet) {
                if (this.internalCache.size() < this.maxCapacity) {
                    leastRecentlyAccessedEntry = null;
                    break;
                }
                if (leastRecentlyAccessedEntry != null) {
                    CachedValue<V> leastRecentlyAccessedCacheValue;
                    CachedValue<V> cachedValue = entry.getValue();
                    if (!cachedValue.wasAccessedLessRecentlyThan(leastRecentlyAccessedCacheValue = leastRecentlyAccessedEntry.getValue())) continue;
                    leastRecentlyAccessedEntry = entry;
                    continue;
                }
                leastRecentlyAccessedEntry = entry;
            }
            if (leastRecentlyAccessedEntry != null) {
                this.internalCache.remove(leastRecentlyAccessedEntry.getKey());
            }
        }
    }

    private static final class CachedValue<V> {
        private final V value;
        private volatile long lastAccessTimeInNanoSeconds = System.nanoTime();

        public CachedValue(V value) {
            this.value = value;
        }

        public long getLastAccessTimeInNanoSeconds() {
            return this.lastAccessTimeInNanoSeconds;
        }

        public V getValue() {
            this.lastAccessTimeInNanoSeconds = System.nanoTime();
            return this.value;
        }

        public boolean wasAccessedLessRecentlyThan(CachedValue otherCachedValue) {
            boolean accessedLessRecentlyThanOtherCachedValue = true;
            if (otherCachedValue != null) {
                long otherLastAccessTime;
                long lastAccessTime = this.getLastAccessTimeInNanoSeconds();
                accessedLessRecentlyThanOtherCachedValue = lastAccessTime - (otherLastAccessTime = otherCachedValue.getLastAccessTimeInNanoSeconds()) < 0L;
            }
            return accessedLessRecentlyThanOtherCachedValue;
        }
    }
}

