/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.cache.internal;

import com.liferay.faces.util.cache.Cache;
import com.liferay.faces.util.cache.CacheFactory;
import com.liferay.faces.util.cache.internal.ConcurrentCacheImpl;
import com.liferay.faces.util.cache.internal.ConcurrentLRUCacheImpl;

public class CacheFactoryImpl
extends CacheFactory {
    @Override
    public <K, V> Cache<K, V> getConcurrentCache(int initialCapacity) throws IllegalArgumentException {
        this.validateInitialCapacity(initialCapacity);
        return new ConcurrentCacheImpl(initialCapacity);
    }

    @Override
    public <K, V> Cache<K, V> getConcurrentLRUCache(int initialCapacity, int maxCapacity) throws IllegalArgumentException {
        this.validateInitialCapacity(initialCapacity);
        this.validateMaxCapacity(maxCapacity);
        return new ConcurrentLRUCacheImpl(initialCapacity, maxCapacity);
    }

    @Override
    public CacheFactory getWrapped() {
        return null;
    }

    private void validateInitialCapacity(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Invalid initialCapacity of " + initialCapacity + ". initialCapacity must be greater than -1.");
        }
    }

    private void validateMaxCapacity(int maxCapacity) {
        if (maxCapacity < 1) {
            throw new IllegalArgumentException("Invalid maxCapacity of " + maxCapacity + ". maxCapacity must be greater than 0.");
        }
    }
}

