/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.application.internal;

import com.liferay.faces.util.application.ResourceValidator;
import com.liferay.faces.util.application.ResourceValidatorFactory;
import com.liferay.faces.util.application.internal.ResourceValidatorImpl;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

public class ResourceValidatorFactoryImpl
extends ResourceValidatorFactory
implements Serializable {
    private static final long serialVersionUID = 1540511281114845438L;
    private static final Logger logger = LoggerFactory.getLogger(ResourceValidatorFactoryImpl.class);
    private ResourceValidator resourceValidator;

    public ResourceValidatorFactoryImpl() {
        ExternalContext externalContext;
        String resourceExcludes;
        String excludeResourceExtensions = null;
        FacesContext startupFacesContext = FacesContext.getCurrentInstance();
        if (startupFacesContext != null && ((resourceExcludes = (externalContext = startupFacesContext.getExternalContext()).getInitParameter("javax.faces.RESOURCE_EXCLUDES")) == null || resourceExcludes.trim().length() == 0)) {
            excludeResourceExtensions = ".class .jsp .jspx .properties .xhtml .groovy";
        }
        ArrayList<Pattern> excludeResourcePatterns = null;
        ArrayList<Pattern> excludeLibraryPatterns = null;
        if (excludeResourceExtensions != null) {
            String[] extensions = excludeResourceExtensions.split(" ");
            excludeResourcePatterns = new ArrayList<Pattern>(extensions.length + 1);
            for (String extension : extensions) {
                Pattern pattern = Pattern.compile(".*\\" + extension + ".*");
                excludeResourcePatterns.add(pattern);
                logger.debug("Excluding resource pattern=[{0}]", pattern);
            }
            Pattern pattern = Pattern.compile("^\\..*");
            excludeResourcePatterns.add(pattern);
            logger.debug("Excluding resource pattern=[{0}]", pattern);
            excludeLibraryPatterns = new ArrayList<Pattern>(1);
            excludeLibraryPatterns.add(pattern);
            logger.debug("Excluding library pattern=[{0}]", pattern);
        }
        this.resourceValidator = new ResourceValidatorImpl(excludeResourcePatterns, excludeLibraryPatterns);
    }

    @Override
    public ResourceValidator getResourceValidator() {
        return this.resourceValidator;
    }

    @Override
    public ResourceValidatorFactory getWrapped() {
        return null;
    }
}

