/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.util.internal;

import com.liferay.faces.bridge.internal.BridgeURLBaseCompat;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.render.FacesURLEncoder;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.context.ExternalContext;
import javax.faces.context.ResponseWriter;
import javax.portlet.faces.Bridge;

public final class URLUtil {
    private static final Logger logger = LoggerFactory.getLogger(URLUtil.class);

    private URLUtil() {
        throw new AssertionError();
    }

    public static String encodeParameterNameOrValue(String nameOrValue, String encoding) throws UnsupportedEncodingException {
        String encodedNameOrValue = nameOrValue;
        if (nameOrValue != null) {
            encodedNameOrValue = URLEncoder.encode(nameOrValue, encoding);
        }
        return encodedNameOrValue;
    }

    public static String[] encodeParameterValues(String[] values, String encoding) throws UnsupportedEncodingException {
        return URLUtil.encodeOrDecodeParameterValues(true, values, encoding);
    }

    public static String encodeURL(String url, FacesURLEncoder facesURLEncoder, String encoding) {
        String encodedURL = url;
        if (url != null) {
            encodedURL = url.replace(" ", "%20");
            encodedURL = facesURLEncoder.encode(encodedURL, encoding);
            encodedURL = encodedURL.replace("&amp;", "&");
        }
        return encodedURL;
    }

    public static String getURLCharacterEncoding(ExternalContext externalContext, ResponseWriter responseWriter, String defaultEncoding) {
        Map requestMap = externalContext.getRequestMap();
        Bridge.PortletPhase portletPhase = (Bridge.PortletPhase)requestMap.get("javax.portlet.faces.phase");
        return URLUtil.getURLCharacterEncoding(portletPhase, externalContext, responseWriter, defaultEncoding);
    }

    public static String getURLCharacterEncoding(Bridge.PortletPhase portletPhase, ExternalContext externalContext, ResponseWriter responseWriter, String defaultEncoding) {
        String encoding = defaultEncoding;
        if (BridgeURLBaseCompat.isHeaderOrRenderOrResourcePhase(portletPhase)) {
            encoding = externalContext.getResponseCharacterEncoding();
        } else if (responseWriter != null) {
            encoding = responseWriter.getCharacterEncoding();
        }
        return encoding;
    }

    public static Map<String, String[]> parseParameterMapValuesArray(String url, String encoding) {
        int pos;
        LinkedHashMap<String, String[]> parameterMapValuesArray = new LinkedHashMap<String, String[]>();
        if (url != null && (pos = url.indexOf("?")) > 0) {
            String queryString = url.substring(pos + 1);
            if ((queryString = queryString.replaceAll("&amp;", "&")) != null && queryString.length() > 0) {
                String[] queryParameters;
                pos = queryString.indexOf("#");
                if (pos > 0) {
                    queryString = queryString.substring(0, pos);
                }
                for (String queryParameter : queryParameters = queryString.split("[&]")) {
                    String[] newValues;
                    String[] nameValueArray = queryParameter.split("[=]");
                    String name = nameValueArray[0].trim();
                    String[] existingValues = (String[])parameterMapValuesArray.get(name);
                    if (nameValueArray.length == 1) {
                        if (existingValues == null) {
                            newValues = new String[]{""};
                        } else {
                            newValues = Arrays.copyOf(existingValues, existingValues.length + 1);
                            newValues[existingValues.length] = "";
                        }
                        URLUtil.putParameter(parameterMapValuesArray, name, newValues, encoding);
                        continue;
                    }
                    if (nameValueArray.length == 2) {
                        if (name.length() == 0) {
                            logger.error("Invalid name=value pair=[{0}] in URL=[{1}]: name cannot be empty", new Object[]{nameValueArray, url});
                            continue;
                        }
                        if (existingValues == null) {
                            newValues = new String[]{nameValueArray[1]};
                        } else {
                            newValues = Arrays.copyOf(existingValues, existingValues.length + 1);
                            newValues[existingValues.length] = nameValueArray[1];
                        }
                        URLUtil.putParameter(parameterMapValuesArray, name, newValues, encoding);
                        continue;
                    }
                    logger.error("Invalid name=value pair=[{0}] in URL=[{1}]", new Object[]{nameValueArray, url});
                }
            }
        }
        return parameterMapValuesArray;
    }

    public static Map<String, List<String>> parseParameterMapValuesList(String url) {
        LinkedHashMap<String, List<String>> parameterMapValuesList = new LinkedHashMap<String, List<String>>();
        Map<String, String[]> parameterMapValuesArray = URLUtil.parseParameterMapValuesArray(url, null);
        Set<Map.Entry<String, String[]>> entrySet = parameterMapValuesArray.entrySet();
        for (Map.Entry<String, String[]> mapEntry : entrySet) {
            String[] mapEntryValues = mapEntry.getValue();
            ArrayList<String> values = new ArrayList<String>(mapEntryValues.length);
            for (int i = 0; i < mapEntryValues.length; ++i) {
                values.add(mapEntryValues[i]);
            }
            parameterMapValuesList.put(mapEntry.getKey(), values);
        }
        return parameterMapValuesList;
    }

    private static String decodeParameterNameOrValue(String nameOrValue, String encoding) throws UnsupportedEncodingException {
        String decodedNameOrValue = nameOrValue;
        if (nameOrValue != null) {
            decodedNameOrValue = URLDecoder.decode(nameOrValue, encoding);
        }
        return decodedNameOrValue;
    }

    private static String[] decodeParameterValues(String[] values, String encoding) throws UnsupportedEncodingException {
        return URLUtil.encodeOrDecodeParameterValues(false, values, encoding);
    }

    private static String[] encodeOrDecodeParameterValues(boolean encode, String[] values, String encoding) throws UnsupportedEncodingException {
        String[] encodedValues = values;
        if (values != null) {
            encodedValues = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                encodedValues[i] = encode ? URLUtil.encodeParameterNameOrValue(values[i], encoding) : URLUtil.decodeParameterNameOrValue(values[i], encoding);
            }
        }
        return encodedValues;
    }

    private static void putParameter(Map<String, String[]> parameterMapValuesArray, String name, String[] newValues, String encoding) {
        if (encoding != null) {
            try {
                name = URLUtil.decodeParameterNameOrValue(name, encoding);
                newValues = URLUtil.decodeParameterValues(newValues, encoding);
            }
            catch (UnsupportedEncodingException e) {
                logger.error("Unable to decode parameter name=\"{0}\" and values=\"{1}\" with encoding \"{2}\".", new Object[]{name, newValues, encoding});
                logger.error((Throwable)e);
            }
        }
        parameterMapValuesArray.put(name, newValues);
    }
}

