/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.cdi.internal;

import com.liferay.faces.bridge.util.internal.RequestMapUtil;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Priority;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.AnnotationLiteral;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.portlet.ActionParameters;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.ClientDataRequest;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.HeaderRequest;
import javax.portlet.HeaderResponse;
import javax.portlet.MimeResponse;
import javax.portlet.MutableRenderParameters;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderParameters;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.StateAwareResponse;
import javax.portlet.WindowState;
import javax.portlet.annotations.ContextPath;
import javax.portlet.annotations.Namespace;
import javax.portlet.annotations.PortletName;
import javax.portlet.annotations.WindowId;
import javax.servlet.http.Cookie;

@Alternative
@Dependent
@Priority(value=2010)
public class BridgeAlternativesProducer {
    private static final Logger logger = LoggerFactory.getLogger(BridgeAlternativesProducer.class);
    @Inject
    private BeanManager beanManager;

    @Named(value="actionParams")
    @Dependent
    @Produces
    @Typed(value={ActionParameters.class})
    public ActionParameters getActionParameters() {
        ActionRequest actionRequest = this.getActionRequest();
        if (actionRequest != null) {
            return actionRequest.getActionParameters();
        }
        return null;
    }

    @Named(value="actionRequest")
    @Dependent
    @Produces
    @Typed(value={ActionRequest.class})
    public ActionRequest getActionRequest() {
        ActionRequest portletRequest = this._getPortletRequest(ActionRequest.class);
        if (portletRequest != null && portletRequest instanceof ActionRequest) {
            ActionRequest actionRequest = portletRequest;
            return actionRequest;
        }
        return null;
    }

    @Named(value="actionResponse")
    @Dependent
    @Produces
    @Typed(value={ActionResponse.class})
    public ActionResponse getActionResponse() {
        ActionResponse portletResponse = this._getPortletResponse(ActionResponse.class);
        if (portletResponse != null && portletResponse instanceof ActionResponse) {
            return portletResponse;
        }
        return null;
    }

    @Named(value="clientDataRequest")
    @Dependent
    @Produces
    @Typed(value={ClientDataRequest.class})
    public ClientDataRequest getClientDataRequest() {
        ClientDataRequest portletRequest = this._getPortletRequest(ClientDataRequest.class);
        if (portletRequest != null && portletRequest instanceof ClientDataRequest) {
            ClientDataRequest clientDataRequest = portletRequest;
            return clientDataRequest;
        }
        return null;
    }

    @Dependent
    @Named(value="contextPath")
    @ContextPath
    @Produces
    public String getContextPath() {
        PortletContext portletContext = this.getPortletContext();
        if (portletContext != null) {
            return portletContext.getContextPath();
        }
        return null;
    }

    @Dependent
    @Named(value="cookies")
    @Produces
    public List<Cookie> getCookies() {
        PortletRequest portletRequest = this._getPortletRequest();
        if (portletRequest == null) {
            return null;
        }
        Cookie[] cookies = portletRequest.getCookies();
        if (cookies == null) {
            return null;
        }
        return Arrays.asList(cookies);
    }

    @Named(value="eventRequest")
    @Dependent
    @Produces
    @Typed(value={EventRequest.class})
    public EventRequest getEventRequest() {
        EventRequest portletRequest = this._getPortletRequest(EventRequest.class);
        if (portletRequest != null && portletRequest instanceof EventRequest) {
            return portletRequest;
        }
        return null;
    }

    @Named(value="eventResponse")
    @Dependent
    @Produces
    @Typed(value={EventResponse.class})
    public EventResponse getEventResponse() {
        EventResponse portletResponse = this._getPortletResponse(EventResponse.class);
        if (portletResponse != null && portletResponse instanceof EventResponse) {
            return portletResponse;
        }
        return null;
    }

    @Named(value="headerRequest")
    @Dependent
    @Produces
    @Typed(value={HeaderRequest.class})
    public HeaderRequest getHeaderRequest() {
        HeaderRequest portletRequest = this._getPortletRequest(HeaderRequest.class);
        if (portletRequest != null && portletRequest instanceof HeaderRequest) {
            return portletRequest;
        }
        return null;
    }

    @Named(value="headerResponse")
    @Dependent
    @Produces
    @Typed(value={HeaderResponse.class})
    public HeaderResponse getHeaderResponse() {
        HeaderResponse portletResponse = this._getPortletResponse(HeaderResponse.class);
        if (portletResponse != null && portletResponse instanceof HeaderResponse) {
            return portletResponse;
        }
        return null;
    }

    @Dependent
    @Named(value="locales")
    @Produces
    public List<Locale> getLocales() {
        PortletRequest portletRequest = this._getPortletRequest();
        if (portletRequest == null) {
            return null;
        }
        return Collections.list(portletRequest.getLocales());
    }

    @Named(value="mimeResponse")
    @Dependent
    @Produces
    @Typed(value={MimeResponse.class})
    public MimeResponse getMimeResponse() {
        MimeResponse portletResponse = this._getPortletResponse(MimeResponse.class);
        if (portletResponse != null && portletResponse instanceof MimeResponse) {
            return portletResponse;
        }
        return null;
    }

    @Named(value="mutableRenderParams")
    @Dependent
    @Produces
    @Typed(value={MutableRenderParameters.class})
    public MutableRenderParameters getMutableRenderParameters() {
        StateAwareResponse stateAwareResponse = this.getStateAwareResponse();
        if (stateAwareResponse != null) {
            return stateAwareResponse.getRenderParameters();
        }
        return null;
    }

    @Dependent
    @Named(value="namespace")
    @Namespace
    @Produces
    public String getNamespace() {
        PortletResponse portletResponse = this._getPortletResponse();
        if (portletResponse == null) {
            return null;
        }
        return portletResponse.getNamespace();
    }

    @Dependent
    @Named(value="portletConfig")
    @Produces
    public PortletConfig getPortletConfig() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            return this._getNonAlternativeDefaultBean(PortletConfig.class);
        }
        return RequestMapUtil.getPortletConfig(facesContext);
    }

    @Dependent
    @Named(value="portletContext")
    @Produces
    public PortletContext getPortletContext() {
        PortletConfig portletConfig = this.getPortletConfig();
        if (portletConfig == null) {
            return this._getNonAlternativeDefaultBean(PortletContext.class);
        }
        return portletConfig.getPortletContext();
    }

    @Dependent
    @Named(value="portletMode")
    @Produces
    public PortletMode getPortletMode() {
        PortletRequest portletRequest = this._getPortletRequest();
        if (portletRequest == null) {
            return null;
        }
        return portletRequest.getPortletMode();
    }

    @Dependent
    @Named(value="portletName")
    @PortletName
    @Produces
    public String getPortletName() {
        PortletConfig portletConfig = this.getPortletConfig();
        if (portletConfig == null) {
            return null;
        }
        return portletConfig.getPortletName();
    }

    @Dependent
    @Named(value="portletPreferences")
    @Produces
    public PortletPreferences getPortletPreferences() {
        PortletRequest portletRequest = this._getPortletRequest();
        if (portletRequest == null) {
            return null;
        }
        return portletRequest.getPreferences();
    }

    @Named(value="portletRequest")
    @Dependent
    @Produces
    public PortletRequest getPortletRequest() {
        return this._getPortletRequest();
    }

    @Named(value="portletResponse")
    @Dependent
    @Produces
    public PortletResponse getPortletResponse() {
        return this._getPortletResponse();
    }

    @Named(value="portletSession")
    @Dependent
    @Produces
    public PortletSession getPortletSession() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            return this._getNonAlternativeDefaultBean(PortletSession.class);
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        return (PortletSession)externalContext.getSession(true);
    }

    @Named(value="renderParams")
    @Dependent
    @Produces
    @Typed(value={RenderParameters.class})
    public RenderParameters getRenderParameters() {
        PortletRequest portletRequest = this._getPortletRequest();
        if (portletRequest == null) {
            return null;
        }
        return portletRequest.getRenderParameters();
    }

    @Named(value="renderRequest")
    @Dependent
    @Produces
    @Typed(value={RenderRequest.class})
    public RenderRequest getRenderRequest() {
        RenderRequest portletRequest = this._getPortletRequest(RenderRequest.class);
        if (portletRequest != null && portletRequest instanceof RenderRequest) {
            return portletRequest;
        }
        return null;
    }

    @Named(value="renderResponse")
    @Dependent
    @Produces
    @Typed(value={RenderResponse.class})
    public RenderResponse getRenderResponse() {
        RenderResponse portletResponse = this._getPortletResponse(RenderResponse.class);
        if (portletResponse != null && portletResponse instanceof RenderResponse) {
            return portletResponse;
        }
        return null;
    }

    @Named(value="resourceRequest")
    @Dependent
    @Produces
    @Typed(value={ResourceRequest.class})
    public ResourceRequest getResourceRequest() {
        ResourceRequest portletRequest = this._getPortletRequest(ResourceRequest.class);
        if (portletRequest != null && portletRequest instanceof ResourceRequest) {
            return portletRequest;
        }
        return null;
    }

    @Named(value="resourceResponse")
    @Dependent
    @Produces
    @Typed(value={ResourceResponse.class})
    public ResourceResponse getResourceResponse() {
        ResourceResponse portletResponse = this._getPortletResponse(ResourceResponse.class);
        if (portletResponse != null && portletResponse instanceof ResourceResponse) {
            return portletResponse;
        }
        return null;
    }

    @Named(value="stateAwareResponse")
    @Dependent
    @Produces
    @Typed(value={StateAwareResponse.class})
    public StateAwareResponse getStateAwareResponse() {
        StateAwareResponse portletResponse = this._getPortletResponse(StateAwareResponse.class);
        if (portletResponse != null && portletResponse instanceof StateAwareResponse) {
            return portletResponse;
        }
        return null;
    }

    @Dependent
    @Named(value="windowId")
    @Produces
    @WindowId
    public String getWindowID() {
        PortletRequest portletRequest = this._getPortletRequest();
        if (portletRequest == null) {
            return null;
        }
        return portletRequest.getWindowID();
    }

    @Dependent
    @Named(value="windowState")
    @Produces
    public WindowState getWindowState() {
        PortletRequest portletRequest = this._getPortletRequest();
        if (portletRequest == null) {
            return null;
        }
        return portletRequest.getWindowState();
    }

    private <T> T _getNonAlternativeDefaultBean(Class<T> clazz) {
        Set beans = this.beanManager.getBeans(clazz, new Annotation[]{DefaultAnnotation.INSTANCE});
        for (Bean bean : beans) {
            Class beanClass = bean.getBeanClass();
            String beanClassName = beanClass.getName();
            if (beanClassName.contains(this.getClass().getPackage().getName())) continue;
            CreationalContext creationalContext = this.beanManager.createCreationalContext((Contextual)bean);
            Object beanInstance = this.beanManager.getReference(bean, clazz, creationalContext);
            logger.debug("beanClassName=[{}] beanInstance=[{}]", new Object[]{beanClassName, beanInstance});
            return (T)beanInstance;
        }
        return null;
    }

    private PortletRequest _getPortletRequest() {
        return this._getPortletRequest(PortletRequest.class);
    }

    private <T extends PortletRequest> T _getPortletRequest(Class<T> clazz) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            return (T)((PortletRequest)this._getNonAlternativeDefaultBean(clazz));
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        return (T)((PortletRequest)externalContext.getRequest());
    }

    private PortletResponse _getPortletResponse() {
        return this._getPortletResponse(PortletResponse.class);
    }

    private <T extends PortletResponse> T _getPortletResponse(Class<T> clazz) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            return (T)((PortletResponse)this._getNonAlternativeDefaultBean(clazz));
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        return (T)((PortletResponse)externalContext.getResponse());
    }

    private static class DefaultAnnotation
    extends AnnotationLiteral<Default>
    implements Default {
        public static final DefaultAnnotation INSTANCE = new DefaultAnnotation();

        private DefaultAnnotation() {
        }
    }
}

