/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.util.internal;

import com.liferay.faces.bridge.BridgeFactoryFinder;
import com.liferay.faces.util.factory.FactoryExtensionFinder;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.product.Product;
import com.liferay.faces.util.product.ProductFactory;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.portlet.PortalContext;
import javax.portlet.PortletContext;

public class FacesRuntimeUtil {
    private static final Logger logger = LoggerFactory.getLogger(FacesRuntimeUtil.class);

    private FacesRuntimeUtil() {
        throw new AssertionError();
    }

    public static boolean isAbleToNamespaceViewState(PortalContext portalContext, ExternalContext externalContext) {
        Map applicationMap;
        Boolean namespacedViewStateSupported = false;
        if (FacesRuntimeUtil.isStrictParameterNamespacingSupported(portalContext) && (namespacedViewStateSupported = (Boolean)(applicationMap = externalContext.getApplicationMap()).get(FacesRuntimeUtil.class.getName())) == null) {
            ProductFactory productFactory = (ProductFactory)FactoryExtensionFinder.getFactory((ExternalContext)externalContext, ProductFactory.class);
            namespacedViewStateSupported = FacesRuntimeUtil.isNamespacedViewStateSupported(productFactory);
        }
        return namespacedViewStateSupported;
    }

    public static boolean isNamespaceViewState(boolean strictParameterNamespacingSupported, PortletContext portletContext) {
        Boolean namespacedViewStateSupported = false;
        if (strictParameterNamespacingSupported && (namespacedViewStateSupported = (Boolean)portletContext.getAttribute(FacesRuntimeUtil.class.getName())) == null) {
            ProductFactory productFactory = (ProductFactory)BridgeFactoryFinder.getFactory((PortletContext)portletContext, ProductFactory.class);
            namespacedViewStateSupported = FacesRuntimeUtil.isNamespacedViewStateSupported(productFactory);
        }
        return namespacedViewStateSupported;
    }

    public static boolean isStrictParameterNamespacingSupported(PortalContext portalContext) {
        String strictNamespacedParametersSupport = portalContext.getProperty("com.liferay.faces.bridge.strict.namespaced.paramters.support");
        return strictNamespacedParametersSupport != null;
    }

    private static boolean isNamespacedViewStateSupported(ProductFactory productFactory) {
        boolean namespacedViewStateSupported = false;
        Product MOJARRA = productFactory.getProductInfo(Product.Name.MOJARRA);
        Product JSF = productFactory.getProductInfo(Product.Name.JSF);
        int jsfMajorVersion = JSF.getMajorVersion();
        if (MOJARRA.isDetected()) {
            int mojarraMajorVersion = MOJARRA.getMajorVersion();
            if (mojarraMajorVersion == 2) {
                int mojarraMinorVersion = MOJARRA.getMinorVersion();
                if (mojarraMinorVersion == 1) {
                    namespacedViewStateSupported = MOJARRA.getPatchVersion() >= 27;
                } else if (mojarraMinorVersion == 2) {
                    namespacedViewStateSupported = MOJARRA.getPatchVersion() >= 4;
                } else if (mojarraMinorVersion > 2) {
                    namespacedViewStateSupported = true;
                }
            } else if (mojarraMajorVersion > 2) {
                namespacedViewStateSupported = true;
            }
        } else if (jsfMajorVersion > 2 || jsfMajorVersion == 2 && JSF.getMinorVersion() >= 3) {
            namespacedViewStateSupported = true;
        }
        logger.debug("JSF runtime [{0}] version [{1}].[{2}].[{3}] supports namespacing [{4}]: [{5}]", new Object[]{JSF.getTitle(), jsfMajorVersion, JSF.getMinorVersion(), JSF.getPatchVersion(), "javax.faces.ViewState", namespacedViewStateSupported});
        return namespacedViewStateSupported;
    }
}

