/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.map.internal;

import com.liferay.faces.bridge.BridgeFactoryFinder;
import com.liferay.faces.bridge.bean.BeanManager;
import com.liferay.faces.bridge.bean.BeanManagerFactory;
import com.liferay.faces.bridge.bean.PreDestroyInvoker;
import com.liferay.faces.bridge.bean.PreDestroyInvokerFactory;
import com.liferay.faces.bridge.context.map.internal.AbstractMutablePropertyMap;
import com.liferay.faces.bridge.context.map.internal.ApplicationScopeMapEntry;
import com.liferay.faces.util.config.ApplicationConfig;
import com.liferay.faces.util.map.AbstractPropertyMapEntry;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletContext;

public class ApplicationScopeMap
extends AbstractMutablePropertyMap<Object> {
    private BeanManager beanManager;
    private PortletContext portletContext;
    private PreDestroyInvoker preDestroyInvoker;
    private boolean preferPreDestroy;

    public ApplicationScopeMap(PortletContext portletContext, boolean preferPreDestroy) {
        BeanManagerFactory beanManagerFactory = (BeanManagerFactory)BridgeFactoryFinder.getFactory((PortletContext)portletContext, BeanManagerFactory.class);
        this.portletContext = portletContext;
        String appConfigAttrName = ApplicationConfig.class.getName();
        ApplicationConfig applicationConfig = (ApplicationConfig)this.portletContext.getAttribute(appConfigAttrName);
        this.beanManager = beanManagerFactory.getBeanManager(applicationConfig.getFacesConfig());
        this.preferPreDestroy = preferPreDestroy;
        PreDestroyInvokerFactory preDestroyInvokerFactory = (PreDestroyInvokerFactory)BridgeFactoryFinder.getFactory((PortletContext)portletContext, PreDestroyInvokerFactory.class);
        this.preDestroyInvoker = preDestroyInvokerFactory.getPreDestroyInvoker(portletContext);
    }

    public void clear() {
        Set mapEntries = this.entrySet();
        if (mapEntries != null) {
            for (Map.Entry mapEntry : mapEntries) {
                Object potentialManagedBeanValue;
                String potentialManagedBeanName = (String)mapEntry.getKey();
                if (!this.beanManager.isManagedBean(potentialManagedBeanName, potentialManagedBeanValue = mapEntry.getValue())) continue;
                this.preDestroyInvoker.invokeAnnotatedMethods(potentialManagedBeanValue, this.preferPreDestroy);
            }
        }
        super.clear();
    }

    public Object remove(Object key) {
        String potentialManagedBeanName = (String)key;
        Object potentialManagedBeanValue = super.remove(key);
        if (this.beanManager.isManagedBean(potentialManagedBeanName, potentialManagedBeanValue)) {
            this.preDestroyInvoker.invokeAnnotatedMethods(potentialManagedBeanValue, this.preferPreDestroy);
        }
        return potentialManagedBeanValue;
    }

    protected AbstractPropertyMapEntry<Object> createPropertyMapEntry(String name) {
        return new ApplicationScopeMapEntry(this.portletContext, name);
    }

    @Override
    protected Object getMutableProperty(String name) {
        return this.portletContext.getAttribute(name);
    }

    @Override
    protected Enumeration<String> getMutablePropertyNames() {
        return this.portletContext.getAttributeNames();
    }

    @Override
    protected void removeMutableProperty(String name) {
        this.portletContext.removeAttribute(name);
    }

    @Override
    protected void setMutableProperty(String name, Object value) {
        this.portletContext.setAttribute(name, value);
    }
}

