/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.internal;

import com.liferay.faces.util.helper.BooleanHelper;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.portlet.BaseURL;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSecurityException;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;

public final class PortletURLHelper {
    private static final Logger logger = LoggerFactory.getLogger(PortletURLHelper.class);
    public static final Set<String> EXCLUDED_PARAMETER_NAMES;

    private PortletURLHelper() {
        throw new AssertionError();
    }

    public static void setPortletMode(PortletURL portletURL, String portletMode, PortletRequest portletRequest) {
        if (portletMode != null) {
            try {
                PortletMode candidatePortletMode = new PortletMode(portletMode);
                if (portletRequest.isPortletModeAllowed(candidatePortletMode)) {
                    portletURL.setPortletMode(candidatePortletMode);
                }
            }
            catch (PortletModeException e) {
                logger.error(e.getMessage() + " portletMode=[" + portletMode + "]");
            }
        }
    }

    public static void setSecure(BaseURL baseURL, String secure) {
        PortletURLHelper.setSecure(baseURL, BooleanHelper.isTrueToken((String)secure));
    }

    public static void setSecure(BaseURL baseURL, boolean secure) {
        try {
            baseURL.setSecure(secure);
        }
        catch (PortletSecurityException e) {
            logger.debug(e.getMessage());
        }
    }

    public static void setWindowState(PortletURL portletURL, String windowState, PortletRequest portletRequest) {
        if (windowState != null) {
            try {
                WindowState candidateWindowState = new WindowState(windowState);
                if (portletRequest.isWindowStateAllowed(candidateWindowState)) {
                    portletURL.setWindowState(candidateWindowState);
                }
            }
            catch (WindowStateException e) {
                logger.error(e.getMessage() + " windowState=[" + windowState + "]");
            }
        }
    }

    static {
        HashSet<String> excludedParameterNames = new HashSet<String>(3);
        excludedParameterNames.add("javax.portlet.faces.PortletMode");
        excludedParameterNames.add("javax.portlet.faces.Secure");
        excludedParameterNames.add("javax.portlet.faces.WindowState");
        EXCLUDED_PARAMETER_NAMES = Collections.unmodifiableSet(excludedParameterNames);
    }
}

