/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.renderkit.html_basic.internal;

import com.liferay.faces.bridge.util.internal.XMLUtil;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Locale;
import java.util.Stack;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import javax.faces.context.ResponseWriterWrapper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class HeadResponseWriterBase
extends ResponseWriterWrapper {
    private static final Logger logger = LoggerFactory.getLogger(HeadResponseWriterBase.class);
    private ResponseWriter wrappedResponseWriter;
    private Node currentNode;
    private Stack<UIComponent> componentResourceStack;
    private boolean titleElement = false;

    public HeadResponseWriterBase(ResponseWriter wrappedResponseWriter) {
        this.wrappedResponseWriter = wrappedResponseWriter;
        this.componentResourceStack = new Stack();
    }

    public Writer append(char c) throws IOException {
        return this.append(Character.toString(c));
    }

    public Writer append(CharSequence csq, int start, int end) throws IOException {
        return this.append(this.toString(csq, start, end));
    }

    public void close() throws IOException {
    }

    public void endDocument() throws IOException {
    }

    public void endElement(String name) throws IOException {
        if (!"head".equals(name)) {
            if ("title".equals(name)) {
                this.titleElement = false;
            } else {
                if (this.currentNode == null) {
                    throw new IllegalStateException("ResponseWriter.endElement(\"" + name + "\") called before startElement(\"" + name + "\", uiComponent)");
                }
                if (!this.isElement(this.currentNode)) {
                    throw new IllegalStateException("ResponseWriter.endElement() called, but current node is not an element.");
                }
                UIComponent componentResource = this.componentResourceStack.pop();
                if (this.isDirectDescendantOfHead(this.currentNode)) {
                    String nodeName = this.currentNode.getNodeName();
                    logger.trace("POPPED element name=[{0}]", new Object[]{nodeName});
                    if (!name.equals(nodeName)) {
                        throw new IllegalStateException("Current element node name [\"" + nodeName + "\"] does not match name passed to endElement() [\"" + name + "\"].");
                    }
                    this.writeNodeToHeadSection(this.currentNode, componentResource);
                    this.currentNode = null;
                } else {
                    this.currentNode = this.currentNode.getParentNode();
                }
            }
        }
    }

    public void flush() throws IOException {
    }

    public ResponseWriter getWrapped() {
        return this.wrappedResponseWriter;
    }

    public void startDocument() throws IOException {
    }

    public void startElement(String name, UIComponent uiComponent) throws IOException {
        if (!"head".equals(name)) {
            if ("title".equals(name)) {
                logger.warn("Title removed because multiple <title> elements are invalid and the portlet container controls the <title>.");
                this.titleElement = true;
            } else {
                if (this.currentNode == null) {
                    this.currentNode = this.createElement(name);
                } else {
                    if (!this.isElement(this.currentNode)) {
                        throw new IllegalStateException("ResponseWriter.startElement() called, but parent node is not an element.");
                    }
                    Node element = this.createElement(name);
                    this.currentNode.appendChild(element);
                    this.currentNode = element;
                }
                this.componentResourceStack.push(uiComponent);
                logger.trace("PUSHED element name=[{0}]", new Object[]{name});
            }
        }
    }

    public void write(int c) throws IOException {
        this.write(Character.toChars(c));
    }

    public void write(char[] cbuf) throws IOException {
        this.write(String.valueOf(cbuf));
    }

    public void write(String str) throws IOException {
        this.append(str);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.write(this.toString(cbuf, off, len));
    }

    public void write(String str, int off, int len) throws IOException {
        this.write(this.toString(str, off, len));
    }

    public void writeAttribute(String name, Object value, String property) throws IOException {
        if (this.isElement(this.currentNode)) {
            Element currentElement = (Element)this.currentNode;
            if (value != null) {
                currentElement.setAttribute(name, value.toString());
            } else {
                currentElement.setAttribute(name, null);
            }
        } else {
            throw new IllegalStateException("ResponseWriter.writeAttribute() called before startElement().");
        }
    }

    public void writeText(Object text, String property) throws IOException {
        if (text != null && !this.titleElement) {
            if (this.isEscapeTextXML(this.currentNode)) {
                text = XMLUtil.escapeXML(text.toString());
            }
            this.write(text.toString());
        }
    }

    public void writeText(Object text, UIComponent uiComponent, String property) throws IOException {
        this.writeText(text, property);
    }

    public void writeText(char[] textArray, int off, int len) throws IOException {
        if (textArray != null) {
            this.writeText(this.toString(textArray, off, len), null);
        }
    }

    public void writeURIAttribute(String name, Object value, String property) throws IOException {
        this.writeAttribute(name, value, property);
    }

    protected abstract Node createElement(String var1);

    protected abstract void writeNodeToHeadSection(Node var1, UIComponent var2) throws IOException;

    protected Node getCurrentNode() {
        return this.currentNode;
    }

    protected String getNodeInfo(Node node) {
        String nodeInfo = "";
        short nodeType = node.getNodeType();
        if (this.isElement(node)) {
            nodeInfo = node.getNodeName();
        } else if (nodeType == 4) {
            nodeInfo = "CDATA_SECTION_NODE";
        } else if (nodeType == 8) {
            nodeInfo = "COMMENT_NODE";
        } else if (nodeType == 3) {
            nodeInfo = "TEXT_NODE";
        }
        return nodeInfo;
    }

    protected boolean isElement(Node node) {
        return node != null && node.getNodeType() == 1;
    }

    protected void setCurrentNode(Node newCurrentNode) {
        this.currentNode = newCurrentNode;
    }

    private boolean isDirectDescendantOfHead(Node node) {
        Node parentNode = node.getParentNode();
        return parentNode == null || parentNode.getNodeType() != 1;
    }

    private boolean isEscapeTextXML(Node node) {
        boolean cdataNode = false;
        boolean scriptNode = false;
        boolean styleNode = false;
        if (node != null) {
            if (this.isElement(node)) {
                String nodeName = node.getNodeName();
                String lowerCaseNodeName = nodeName.toLowerCase(Locale.ENGLISH);
                scriptNode = lowerCaseNodeName.equals("script");
                styleNode = lowerCaseNodeName.equals("style");
            } else {
                short nodeType = node.getNodeType();
                cdataNode = nodeType == 4;
            }
        }
        return !cdataNode && !scriptNode && !styleNode;
    }

    private String toString(CharSequence csq, int start, int end) {
        return new StringBuilder(1).append(csq, start, end).toString();
    }

    private String toString(char[] cbuf, int off, int len) {
        return String.valueOf(Arrays.copyOfRange(cbuf, off, len));
    }
}

