/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.model.internal;

import com.liferay.faces.bridge.model.UploadedFile;
import com.liferay.faces.util.model.UploadedFile;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;

public class UploadedFileBridgeImpl
implements Serializable,
UploadedFile {
    private static final long serialVersionUID = 2492812271137403881L;
    private boolean primeFacesDetected;
    private com.liferay.faces.util.model.UploadedFile wrappedUploadedFile;

    public UploadedFileBridgeImpl(com.liferay.faces.util.model.UploadedFile uploadedFile, boolean primeFacesDetected) {
        this.wrappedUploadedFile = uploadedFile;
        this.primeFacesDetected = primeFacesDetected;
    }

    public void delete() throws IOException {
        try {
            File tempDir;
            File[] files;
            File wrappedFile;
            String tempDirPath = null;
            String absolutePath = this.wrappedUploadedFile.getAbsolutePath();
            if (absolutePath != null && (tempDirPath = (wrappedFile = new File(absolutePath)).getParent()) != null && (files = (tempDir = new File(tempDirPath)).listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name != null && name.endsWith(".tmp");
                }
            })) != null) {
                for (File file : files) {
                    file.delete();
                }
            }
            this.wrappedUploadedFile.delete();
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw e;
            }
            throw new IOException(e);
        }
    }

    public String getAbsolutePath() {
        return this.wrappedUploadedFile.getAbsolutePath();
    }

    public Map<String, Object> getAttributes() {
        return this.wrappedUploadedFile.getAttributes();
    }

    public byte[] getBytes() throws IOException {
        return this.wrappedUploadedFile.getBytes();
    }

    public String getCharSet() {
        return this.wrappedUploadedFile.getCharSet();
    }

    public String getContentType() {
        return this.wrappedUploadedFile.getContentType();
    }

    public String getHeader(String name) {
        return this.wrappedUploadedFile.getHeader(name);
    }

    public Collection<String> getHeaderNames() {
        return this.wrappedUploadedFile.getHeaderNames();
    }

    public Collection<String> getHeaders(String name) {
        return this.wrappedUploadedFile.getHeaders(name);
    }

    public String getId() {
        return this.wrappedUploadedFile.getId();
    }

    public InputStream getInputStream() throws IOException {
        if (this.primeFacesDetected) {
            return new DeletingInputStream(this.wrappedUploadedFile.getInputStream());
        }
        return this.wrappedUploadedFile.getInputStream();
    }

    public String getMessage() {
        return this.wrappedUploadedFile.getMessage();
    }

    public String getName() {
        return this.wrappedUploadedFile.getName();
    }

    public long getSize() {
        return this.wrappedUploadedFile.getSize();
    }

    public UploadedFile.Status getStatus() {
        UploadedFile.Status wrappedStatus = this.wrappedUploadedFile.getStatus();
        return UploadedFile.Status.valueOf((String)wrappedStatus.name());
    }

    public void write(String fileName) throws IOException {
        this.wrappedUploadedFile.write(fileName);
    }

    private class DeletingInputStream
    extends InputStream {
        private InputStream wrappedInputStream;

        public DeletingInputStream(InputStream inputStream) {
            this.wrappedInputStream = inputStream;
        }

        @Override
        public void close() throws IOException {
            this.wrappedInputStream.close();
            UploadedFileBridgeImpl.this.delete();
        }

        @Override
        public int read() throws IOException {
            return this.wrappedInputStream.read();
        }
    }
}

