/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.bean.internal;

import com.liferay.faces.bridge.bean.internal.BeanManagerCompatImpl;
import com.liferay.faces.util.config.ConfiguredManagedBean;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BeanManagerImpl
extends BeanManagerCompatImpl {
    private static final String JAVAX_PORTLET_P = "javax.portlet.p.";
    private Map<String, ConfiguredManagedBean> configuredManagedBeanSet = new HashMap<String, ConfiguredManagedBean>();

    public BeanManagerImpl(List<ConfiguredManagedBean> configuredManagedBeans) {
        if (configuredManagedBeans != null) {
            for (ConfiguredManagedBean configuredManagedBean : configuredManagedBeans) {
                this.configuredManagedBeanSet.put(configuredManagedBean.getManagedBeanName(), configuredManagedBean);
            }
        }
    }

    @Override
    public boolean isManagedBean(String name, Object value) {
        boolean managedBean = false;
        if (value != null) {
            if (this.hasManagedBeanAnnotation(value)) {
                managedBean = true;
            } else if (name != null) {
                ConfiguredManagedBean configuredManagedBean;
                int pos;
                if (name.startsWith(JAVAX_PORTLET_P) && (pos = name.indexOf("?")) > 0) {
                    name = name.substring(pos + 1);
                }
                if ((configuredManagedBean = this.configuredManagedBeanSet.get(name)) != null) {
                    String managedBeanClass = value.getClass().getName();
                    managedBean = managedBeanClass.equals(configuredManagedBean.getManagedBeanClass());
                }
            }
        }
        return managedBean;
    }
}

