/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.util.internal;

import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.product.Product;
import com.liferay.faces.util.product.ProductFactory;

public class FacesRuntimeUtil {
    private static final Logger logger = LoggerFactory.getLogger(FacesRuntimeUtil.class);
    private static final boolean JSF_RUNTIME_SUPPORTS_NAMESPACING_VIEWSTATE;

    public static boolean isNamespacedViewStateSupported() {
        return JSF_RUNTIME_SUPPORTS_NAMESPACING_VIEWSTATE;
    }

    static {
        boolean namespacedViewStateSupported = false;
        Product mojarra = ProductFactory.getProduct((Product.Name)Product.Name.MOJARRA);
        if (mojarra.isDetected()) {
            int mojarraMajorVersion = mojarra.getMajorVersion();
            if (mojarraMajorVersion == 2) {
                int mojarraMinorVersion = mojarra.getMinorVersion();
                if (mojarraMinorVersion == 1) {
                    namespacedViewStateSupported = mojarra.getPatchVersion() >= 27;
                } else if (mojarraMinorVersion == 2) {
                    namespacedViewStateSupported = mojarra.getPatchVersion() >= 4;
                } else if (mojarraMinorVersion > 2) {
                    namespacedViewStateSupported = true;
                }
            } else if (mojarraMajorVersion > 2) {
                namespacedViewStateSupported = true;
            }
        }
        Product jsf = ProductFactory.getProduct((Product.Name)Product.Name.JSF);
        logger.debug("JSF runtime [{0}] version [{1}].[{2}].[{3}] supports namespacing [{4}]: [{5}]", new Object[]{jsf.getTitle(), jsf.getMajorVersion(), jsf.getMinorVersion(), jsf.getPatchVersion(), "javax.faces.ViewState", namespacedViewStateSupported});
        JSF_RUNTIME_SUPPORTS_NAMESPACING_VIEWSTATE = namespacedViewStateSupported;
    }
}

