/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.scope.internal;

import com.liferay.faces.bridge.BridgeFactoryFinder;
import com.liferay.faces.bridge.internal.PortletConfigEmptyImpl;
import com.liferay.faces.bridge.internal.PortletConfigParam;
import com.liferay.faces.bridge.scope.internal.BridgeRequestScope;
import com.liferay.faces.bridge.scope.internal.BridgeRequestScopeManager;
import com.liferay.faces.bridge.scope.internal.BridgeRequestScopeManagerFactory;
import com.liferay.faces.util.cache.Cache;
import com.liferay.faces.util.cache.CacheFactory;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;

public class BridgeRequestScopeManagerImpl
implements BridgeRequestScopeManager {
    private static final Logger logger = LoggerFactory.getLogger(BridgeRequestScopeManagerImpl.class);
    private static volatile Cache<String, BridgeRequestScope> bridgeRequestScopeCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Cache<String, BridgeRequestScope> getBridgeRequestScopeCache(PortletContext portletContext) {
        Cache bridgeRequestScopeCache = BridgeRequestScopeManagerImpl.bridgeRequestScopeCache;
        if (bridgeRequestScopeCache != null) return bridgeRequestScopeCache;
        Class<BridgeRequestScopeManagerImpl> clazz = BridgeRequestScopeManagerImpl.class;
        synchronized (BridgeRequestScopeManagerImpl.class) {
            bridgeRequestScopeCache = BridgeRequestScopeManagerImpl.bridgeRequestScopeCache;
            if (bridgeRequestScopeCache != null) return bridgeRequestScopeCache;
            CacheFactory cacheFactory = (CacheFactory)BridgeFactoryFinder.getFactory((PortletContext)portletContext, CacheFactory.class);
            PortletConfigEmptyImpl emptyPortletConfig = new PortletConfigEmptyImpl(portletContext);
            int initialCacheCapacity = PortletConfigParam.BridgeRequestScopeInitialCacheCapacity.getIntegerValue(emptyPortletConfig);
            int maxCacheCapacity = PortletConfigParam.BridgeRequestScopeMaxCacheCapacity.getIntegerValue(emptyPortletConfig);
            if (maxCacheCapacity <= -1) return BridgeRequestScopeManagerImpl.bridgeRequestScopeCache = cacheFactory.getConcurrentCache(initialCacheCapacity);
            BridgeRequestScopeManagerImpl.bridgeRequestScopeCache = cacheFactory.getConcurrentLRUCache(initialCacheCapacity, maxCacheCapacity);
            return BridgeRequestScopeManagerImpl.bridgeRequestScopeCache;
        }
    }

    @Override
    public void removeBridgeRequestScopesByPortlet(PortletConfig portletConfig) {
        String portletNameToRemove = portletConfig.getPortletName();
        PortletContext portletContext = portletConfig.getPortletContext();
        BridgeRequestScopeManager bridgeRequestScopeManager = BridgeRequestScopeManagerFactory.getBridgeRequestScopeManagerInstance(portletContext);
        Cache<String, BridgeRequestScope> bridgeRequestScopeCache = bridgeRequestScopeManager.getBridgeRequestScopeCache(portletContext);
        this.removeBridgeRequestScopes(bridgeRequestScopeCache, true, portletNameToRemove);
    }

    @Override
    public void removeBridgeRequestScopesBySession(HttpSession httpSession) {
        ServletContext servletContext = httpSession.getServletContext();
        Enumeration attributeNames = servletContext.getAttributeNames();
        String sessionId = httpSession.getId();
        while (attributeNames.hasMoreElements()) {
            Object value;
            Object key;
            String attributeName = (String)attributeNames.nextElement();
            Object attribute = servletContext.getAttribute(attributeName);
            if (!(attribute instanceof Cache)) continue;
            boolean bridgeRequestScopeCacheFound = false;
            Cache cache = (Cache)attribute;
            Set keySet = cache.getKeys();
            Iterator iterator = keySet.iterator();
            if (iterator.hasNext() && (key = iterator.next()) instanceof String && (value = cache.getValue(key)) instanceof BridgeRequestScope) {
                bridgeRequestScopeCacheFound = true;
            }
            if (!bridgeRequestScopeCacheFound) continue;
            this.removeBridgeRequestScopes(cache, false, sessionId);
        }
    }

    private void removeBridgeRequestScopes(Cache bridgeRequestScopeCache, boolean removeByPortletId, String portletOrSessionId) {
        int indexOfSessionIdSection = -1;
        ArrayList<String> keysToRemove = new ArrayList<String>();
        Set keySet = bridgeRequestScopeCache.getKeys();
        String portletOrSessionIdWithSeparatorSuffix = portletOrSessionId + ":::";
        for (String bridgeRequestScopeId : keySet) {
            String idWithoutPortletNamePrefix;
            if (removeByPortletId) {
                if (!bridgeRequestScopeId.startsWith(portletOrSessionIdWithSeparatorSuffix)) continue;
                keysToRemove.add(bridgeRequestScopeId);
                continue;
            }
            if (indexOfSessionIdSection < 0) {
                indexOfSessionIdSection = bridgeRequestScopeId.indexOf(":::") + ":::".length();
            }
            if (!(idWithoutPortletNamePrefix = bridgeRequestScopeId.substring(indexOfSessionIdSection)).startsWith(portletOrSessionIdWithSeparatorSuffix)) continue;
            keysToRemove.add(bridgeRequestScopeId);
        }
        for (String keyToRemove : keysToRemove) {
            Object bridgeRequestScope = bridgeRequestScopeCache.removeValue((Object)keyToRemove);
            if (removeByPortletId) continue;
            logger.debug("Removed bridgeRequestScopeId=[{0}] bridgeRequestScope=[{1}] from cache due to session timeout", new Object[]{keyToRemove, bridgeRequestScope});
        }
    }
}

