/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.renderkit.primefaces.internal;

import com.liferay.faces.bridge.BridgeFactoryFinder;
import com.liferay.faces.bridge.context.map.internal.ContextMapFactory;
import com.liferay.faces.bridge.model.UploadedFile;
import com.liferay.faces.bridge.renderkit.primefaces.internal.PrimeFacesFileItem;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.product.Product;
import com.liferay.faces.util.product.ProductFactory;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import javax.faces.render.Renderer;
import javax.faces.render.RendererWrapper;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import org.apache.commons.fileupload.FileItem;

public class FileUploadRendererPrimeFacesImpl
extends RendererWrapper {
    private static final Logger logger = LoggerFactory.getLogger(FileUploadRendererPrimeFacesImpl.class);
    private static final String FQCN_DEFAULT_UPLOADED_FILE = "org.primefaces.model.DefaultUploadedFile";
    private static final String FQCN_FILE_UPLOAD = "org.primefaces.component.fileupload.FileUpload";
    private static final String FQCN_FILE_UPLOAD_EVENT = "org.primefaces.event.FileUploadEvent";
    private static final String FQCN_UPLOADED_FILE = "org.primefaces.model.UploadedFile";
    private Renderer wrappedRenderer;

    public FileUploadRendererPrimeFacesImpl(Renderer renderer) {
        this.wrappedRenderer = renderer;
    }

    static boolean isSimpleMode(UIComponent fileUpload) {
        Map attributes = fileUpload.getAttributes();
        return FileUploadRendererPrimeFacesImpl.isSimpleMode(attributes);
    }

    private static boolean isSimpleMode(Map<String, Object> fileUploadAttributes) {
        Object mode = fileUploadAttributes.get("mode");
        return "simple".equals(mode);
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        Map attributes = uiComponent.getAttributes();
        Object disabled = attributes.get("disabled");
        if (!Boolean.TRUE.equals(disabled)) {
            try {
                PortletRequest portletRequest;
                PortletContext portletContext;
                ContextMapFactory contextMapFactory;
                Map<String, List<UploadedFile>> uploadedFileMap;
                List<UploadedFile> uploadedFiles;
                String clientId = uiComponent.getClientId(facesContext);
                ExternalContext externalContext = facesContext.getExternalContext();
                Map requestParameterMap = externalContext.getRequestParameterMap();
                String submittedValue = (String)requestParameterMap.get(clientId);
                if (submittedValue == null) {
                    Object skinSimple = attributes.get("skinSimple");
                    if (FileUploadRendererPrimeFacesImpl.isSimpleMode(attributes) && Boolean.TRUE.equals(skinSimple)) {
                        clientId = clientId + "_input";
                        submittedValue = (String)requestParameterMap.get(clientId);
                    }
                }
                if (submittedValue != null && (uploadedFiles = (uploadedFileMap = (contextMapFactory = (ContextMapFactory)BridgeFactoryFinder.getFactory((PortletContext)(portletContext = (PortletContext)externalContext.getContext()), ContextMapFactory.class)).getUploadedFileMap(portletRequest = (PortletRequest)externalContext.getRequest())).get(clientId)) != null) {
                    for (UploadedFile uploadedFile : uploadedFiles) {
                        Object defaultUploadedFile;
                        PrimeFacesFileItem fileItem = new PrimeFacesFileItem(clientId, uploadedFile);
                        Product PRIMEFACES = ProductFactory.getProduct((Product.Name)Product.Name.PRIMEFACES);
                        Class<?> defaultUploadedFileClass = Class.forName(FQCN_DEFAULT_UPLOADED_FILE);
                        if (PRIMEFACES.getMajorVersion() > 6 || PRIMEFACES.getMajorVersion() == 6 && PRIMEFACES.getMinorVersion() >= 2) {
                            Class<?> fileUploadClass = Class.forName(FQCN_FILE_UPLOAD);
                            Constructor<?> constructor = defaultUploadedFileClass.getDeclaredConstructor(FileItem.class, fileUploadClass);
                            defaultUploadedFile = constructor.newInstance(fileItem, uiComponent);
                        } else {
                            Constructor<?> constructor = defaultUploadedFileClass.getDeclaredConstructor(FileItem.class);
                            defaultUploadedFile = constructor.newInstance(fileItem);
                        }
                        if (FileUploadRendererPrimeFacesImpl.isSimpleMode(attributes)) {
                            logger.debug("Setting submittedValue=[{0}]", new Object[]{submittedValue});
                            UIInput uiInput = (UIInput)uiComponent;
                            uiInput.setSubmittedValue(defaultUploadedFile);
                            continue;
                        }
                        logger.debug("Queuing FileUploadEvent for submittedValue=[{0}]", new Object[]{submittedValue});
                        Class<?> uploadedFileClass = Class.forName(FQCN_UPLOADED_FILE);
                        Class<?> fileUploadEventClass = Class.forName(FQCN_FILE_UPLOAD_EVENT);
                        Constructor<?> constructor = fileUploadEventClass.getConstructor(UIComponent.class, uploadedFileClass);
                        FacesEvent fileUploadEvent = (FacesEvent)constructor.newInstance(uiComponent, defaultUploadedFile);
                        uiComponent.queueEvent(fileUploadEvent);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
    }

    public Renderer getWrapped() {
        return this.wrappedRenderer;
    }
}

