/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.internal;

import com.liferay.faces.bridge.BridgeConfig;
import com.liferay.faces.bridge.application.internal.BridgeNavigationHandler;
import com.liferay.faces.bridge.application.internal.BridgeNavigationHandlerImpl;
import com.liferay.faces.bridge.context.internal.CapturingWriter;
import com.liferay.faces.bridge.context.internal.WriterOperation;
import com.liferay.faces.bridge.event.internal.IPCPhaseListener;
import com.liferay.faces.bridge.internal.BridgePhaseCompat_2_2_Impl;
import com.liferay.faces.bridge.internal.PortletConfigParam;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.portlet.MimeResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeException;

public abstract class BridgePhaseHeaderRenderCommon
extends BridgePhaseCompat_2_2_Impl {
    private static final Logger logger = LoggerFactory.getLogger(BridgePhaseHeaderRenderCommon.class);

    public BridgePhaseHeaderRenderCommon(PortletConfig portletConfig, BridgeConfig bridgeConfig) {
        super(portletConfig, bridgeConfig);
    }

    protected abstract MimeResponse getMimeResponse();

    protected abstract RenderRequest getRenderRequest();

    protected void executeRender(String renderRedirectViewId, Bridge.PortletPhase portletPhase) throws BridgeException, IOException {
        CapturingWriter capturingWriter;
        List<WriterOperation> writerOperations;
        boolean manageIncongruities;
        ExternalContext externalContext;
        RenderRequest renderRequest = this.getRenderRequest();
        MimeResponse mimeResponse = this.getMimeResponse();
        this.init((PortletRequest)renderRequest, (PortletResponse)mimeResponse, portletPhase);
        boolean facesLifecycleExecuted = this.bridgeRequestScope.isFacesLifecycleExecuted();
        this.bridgeRequestScope.restoreState(this.facesContext);
        if (this.bridgeRequestScope.isPortletModeChanged() || this.bridgeRequestScope.isRedirectOccurred()) {
            this.bridgeRequestScopeCache.removeValue((Object)this.bridgeRequestScope.getId());
        }
        if (renderRedirectViewId != null) {
            renderRequest.setAttribute("com.liferay.faces.bridge.renderRedirectAfterDispatch", (Object)Boolean.TRUE);
            ViewHandler viewHandler = this.facesContext.getApplication().getViewHandler();
            UIViewRoot uiViewRoot = viewHandler.createView(this.facesContext, renderRedirectViewId);
            this.facesContext.setViewRoot(uiViewRoot);
            logger.debug("Performed render-redirect to viewId=[{0}]", new Object[]{renderRedirectViewId});
        } else if (this.bridgeRequestScope.isRedirectOccurred()) {
            facesLifecycleExecuted = false;
        }
        if (this.bridgeRequestScope.getBeganInPhase() == Bridge.PortletPhase.ACTION_PHASE) {
            externalContext = this.facesContext.getExternalContext();
            externalContext.getRequestMap().put("javax.portlet.faces.isPostback", Boolean.TRUE);
        }
        logger.debug("portletName=[{0}] facesLifecycleExecuted=[{1}]", new Object[]{this.portletName, facesLifecycleExecuted});
        if (facesLifecycleExecuted) {
            PhaseListener[] phaseListeners;
            PhaseEvent restoreViewPhaseEvent = new PhaseEvent(this.facesContext, PhaseId.RESTORE_VIEW, this.facesLifecycle);
            for (PhaseListener phaseListener : phaseListeners = this.facesLifecycle.getPhaseListeners()) {
                if (!(phaseListener instanceof IPCPhaseListener)) continue;
                phaseListener.afterPhase(restoreViewPhaseEvent);
                break;
            }
        } else {
            externalContext = this.facesContext.getExternalContext();
            try {
                String viewId = this.getFacesViewId(externalContext);
                logger.debug("Executing Faces lifecycle for viewId=[{0}]", new Object[]{viewId});
            }
            catch (BridgeException e) {
                Writer responseOutputWriter = this.getResponseOutputWriter(externalContext);
                if (responseOutputWriter instanceof CapturingWriter) {
                    CapturingWriter capturingWriter2 = (CapturingWriter)responseOutputWriter;
                    renderRequest.setAttribute("com.liferay.faces.bridge.writerOperations", capturingWriter2.getWriterOperations());
                }
                logger.error("Unable to get viewId due to {0}", new Object[]{((Object)((Object)e)).getClass().getSimpleName()});
                throw e;
            }
            this.attachClientWindowToLifecycle(this.facesContext, this.facesLifecycle);
            this.facesLifecycle.execute(this.facesContext);
        }
        Throwable handledException = this.getJSF2HandledException(this.facesContext);
        if (handledException != null) {
            throw new BridgeException(handledException);
        }
        Throwable unhandledException = this.getJSF2UnhandledException(this.facesContext);
        if (unhandledException != null) {
            throw new BridgeException(unhandledException);
        }
        if (this.bridgeRequestScope.isPortletModeChanged() && !this.bridgeRequestScope.isNavigationOccurred()) {
            BridgeNavigationHandler bridgeNavigationHandler = this.getBridgeNavigationHandler(this.facesContext);
            PortletMode fromPortletMode = this.bridgeRequestScope.getPortletMode();
            PortletMode toPortletMode = renderRequest.getPortletMode();
            bridgeNavigationHandler.handleNavigation(this.facesContext, fromPortletMode, toPortletMode);
        }
        if (manageIncongruities = PortletConfigParam.ManageIncongruities.getBooleanValue(this.portletConfig)) {
            this.incongruityContext.makeCongruous(this.facesContext);
        }
        logger.debug("Executing Faces render");
        this.facesLifecycle.render(this.facesContext);
        this.setViewHistory(this.facesContext.getViewRoot().getViewId());
        this.indicateNamespacingToConsumers(this.facesContext.getViewRoot(), (PortletResponse)mimeResponse);
        ExternalContext externalContext2 = this.facesContext.getExternalContext();
        Map requestMap = externalContext2.getRequestMap();
        Boolean renderRedirect = (Boolean)requestMap.remove("com.liferay.faces.bridge.renderRedirect");
        Writer responseOutputWriter = this.getResponseOutputWriter(externalContext2);
        if (renderRedirect != null && renderRedirect.booleanValue()) {
            this.facesContext.responseComplete();
            this.facesContext.release();
            if (responseOutputWriter instanceof CapturingWriter) {
                CapturingWriter capturingWriter3 = (CapturingWriter)responseOutputWriter;
                capturingWriter3.getWriterOperations().clear();
            }
            renderRedirectViewId = (String)requestMap.remove("com.liferay.faces.bridge.renderRedirectViewId");
            this.executeRender(renderRedirectViewId, portletPhase);
        } else if (responseOutputWriter instanceof CapturingWriter && (writerOperations = (capturingWriter = (CapturingWriter)responseOutputWriter).getWriterOperations()) != null) {
            if (portletPhase == Bridge.PortletPhase.RENDER_PHASE) {
                for (WriterOperation writerOperation : writerOperations) {
                    writerOperation.invoke(responseOutputWriter);
                }
            } else {
                renderRequest.setAttribute("com.liferay.faces.bridge.writerOperations", writerOperations);
            }
        }
    }

    protected BridgeNavigationHandler getBridgeNavigationHandler(FacesContext facesContext) {
        NavigationHandler navigationHandler = facesContext.getApplication().getNavigationHandler();
        BridgeNavigationHandler bridgeNavigationHandler = navigationHandler instanceof BridgeNavigationHandler ? (BridgeNavigationHandler)navigationHandler : new BridgeNavigationHandlerImpl(navigationHandler);
        return bridgeNavigationHandler;
    }

    protected void setViewHistory(String viewId) {
        RenderRequest renderRequest = this.getRenderRequest();
        String attributeName = "javax.portlet.faces.viewIdHistory".concat(".").concat(renderRequest.getPortletMode().toString());
        PortletSession portletSession = renderRequest.getPortletSession();
        portletSession.setAttribute(attributeName, (Object)viewId);
    }
}

