/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.content.targeting.util;

import com.liferay.asset.kernel.exception.NoSuchVocabularyException;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetVocabularyLocalService;
import com.liferay.content.targeting.model.UserSegment;
import com.liferay.content.targeting.service.UserSegmentLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={UserSegmentUtil.class})
public class UserSegmentUtil {
    private AssetVocabularyLocalService _assetVocabularyLocalService;
    private ResourceBundleLoader _resourceBundleLoader;

    public AssetVocabulary addAssetVocabulary(long userId, ServiceContext serviceContext) throws PortalException {
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        AssetVocabulary assetVocabulary = this._assetVocabularyLocalService.addVocabulary(userId, serviceContext.getScopeGroupId(), "", this._getAssetVocabularyTitleMap(), null, "", serviceContext);
        return assetVocabulary;
    }

    public AssetVocabulary getAssetVocabulary(long groupId) throws PortalException {
        AssetVocabulary assetVocabulary = this._getAssetVocabulary(groupId, "user-segments");
        if (assetVocabulary != null) {
            return assetVocabulary;
        }
        Map<Locale, String> titleMap = this._getAssetVocabularyTitleMap();
        assetVocabulary = this._getAssetVocabulary(groupId, titleMap.get(LocaleUtil.getSiteDefault()));
        if (assetVocabulary != null) {
            return assetVocabulary;
        }
        for (Map.Entry<Locale, String> entry : titleMap.entrySet()) {
            assetVocabulary = this._getAssetVocabulary(groupId, entry.getValue());
            if (assetVocabulary == null) continue;
            return assetVocabulary;
        }
        return assetVocabulary;
    }

    public long getAssetVocabularyId(long userId, ServiceContext serviceContext) throws PortalException {
        AssetVocabulary assetVocabulary = this.getAssetVocabulary(serviceContext.getScopeGroupId());
        if (assetVocabulary != null) {
            return assetVocabulary.getVocabularyId();
        }
        Group scopeGroup = serviceContext.getScopeGroup();
        String originalUuid = serviceContext.getUuid();
        if (scopeGroup.isStagingGroup()) {
            AssetVocabulary liveAssetVocabulary = this.getAssetVocabulary(scopeGroup.getLiveGroupId());
            if (liveAssetVocabulary == null) {
                ServiceContext serviceContextLive = (ServiceContext)serviceContext.clone();
                serviceContextLive.setScopeGroupId(scopeGroup.getLiveGroupId());
                liveAssetVocabulary = this.addAssetVocabulary(userId, serviceContextLive);
            }
            serviceContext.setUuid(liveAssetVocabulary.getUuid());
        }
        assetVocabulary = this.addAssetVocabulary(userId, serviceContext);
        serviceContext.setUuid(originalUuid);
        return assetVocabulary.getVocabularyId();
    }

    public long[] getAssetVocabularyIds(long[] groupIds) throws PortalException {
        ServiceContext serviceContext;
        ArrayList<Long> vocabularyIds = new ArrayList<Long>();
        for (long groupId : groupIds) {
            AssetVocabulary assetVocabulary = this.getAssetVocabulary(groupId);
            if (assetVocabulary == null) continue;
            vocabularyIds.add(assetVocabulary.getVocabularyId());
        }
        if (vocabularyIds.isEmpty() && (serviceContext = ServiceContextThreadLocal.getServiceContext()) != null) {
            AssetVocabulary assetVocabulary = this.addAssetVocabulary(serviceContext.getUserId(), serviceContext);
            vocabularyIds.add(assetVocabulary.getVocabularyId());
        }
        return ArrayUtil.toLongArray(vocabularyIds);
    }

    public List<UserSegment> getUserSegments(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<UserSegment> userSegments = new ArrayList<UserSegment>(documents.size());
        for (Document document : documents) {
            long userSegmentId = GetterUtil.getLong((String)document.get("userSegmentId"));
            UserSegment userSegment = UserSegmentLocalServiceUtil.fetchUserSegment(userSegmentId);
            if (userSegment == null) {
                userSegments = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(UserSegment.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (userSegments == null) continue;
            userSegments.add(userSegment);
        }
        return userSegments;
    }

    @Reference(unbind="-")
    public void setAssetVocabularyService(AssetVocabularyLocalService assetVocabularyLocalService) {
        this._assetVocabularyLocalService = assetVocabularyLocalService;
    }

    @Reference(target="(bundle.symbolic.name=com.liferay.content.targeting.lang)", unbind="-")
    public void setResourceBundleLoader(ResourceBundleLoader resourceBundleLoader) {
        this._resourceBundleLoader = resourceBundleLoader;
    }

    private AssetVocabulary _getAssetVocabulary(long groupId, String name) throws PortalException {
        try {
            return this._assetVocabularyLocalService.getGroupVocabulary(groupId, name);
        }
        catch (NoSuchVocabularyException nsve) {
            return null;
        }
    }

    private Map<Locale, String> _getAssetVocabularyTitleMap() {
        HashMap<Locale, String> titleMap = new HashMap<Locale, String>();
        Set locales = LanguageUtil.getAvailableLocales();
        for (Locale locale : locales) {
            ResourceBundle resourceBundle = this._resourceBundleLoader.loadResourceBundle(LanguageUtil.getLanguageId((Locale)locale));
            titleMap.put(locale, ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"user-segment"));
        }
        return titleMap;
    }
}

