/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.content.targeting.util;

import com.liferay.content.targeting.model.Tactic;
import com.liferay.content.targeting.service.TacticLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.ArrayList;
import java.util.List;

public class TacticUtil {
    public static final String[] SELECTED_FIELD_NAMES = new String[]{"companyId", "groupId", "uid", "tacticId"};

    public static List<Tactic> getTactics(Hits hits) throws PortalException {
        ArrayList<Tactic> tactics = null;
        if (hits != null) {
            List documents = hits.toList();
            tactics = new ArrayList(documents.size());
            for (Document document : documents) {
                long tacticId = GetterUtil.getLong((String)document.get("tacticId"));
                Tactic tactic = TacticLocalServiceUtil.fetchTactic(tacticId);
                if (tactic == null) {
                    tactics = null;
                    Indexer indexer = IndexerRegistryUtil.getIndexer(Tactic.class);
                    long companyId = GetterUtil.getLong((String)document.get("companyId"));
                    indexer.delete(companyId, document.getUID());
                    continue;
                }
                if (tactics == null) continue;
                tactics.add(tactic);
            }
        } else {
            tactics = new ArrayList<Tactic>(0);
        }
        return tactics;
    }
}

