/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.content.targeting.util;

import com.liferay.content.targeting.model.Campaign;
import com.liferay.content.targeting.service.CampaignLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.ArrayList;
import java.util.List;

public class CampaignUtil {
    public static final String[] SELECTED_FIELD_NAMES = new String[]{"companyId", "groupId", "uid", "campaignId"};

    public static List<Campaign> getCampaigns(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<Campaign> campaigns = new ArrayList<Campaign>(documents.size());
        for (Document document : documents) {
            long campaignId = GetterUtil.getLong((String)document.get("campaignId"));
            Campaign campaign = CampaignLocalServiceUtil.fetchCampaign(campaignId);
            if (campaign == null) {
                campaigns = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(Campaign.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (campaigns == null) continue;
            campaigns.add(campaign);
        }
        return campaigns;
    }
}

