/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.content.targeting.upgrade.classname;

import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.upgrade.v7_0_0.UpgradeKernelPackage;

public abstract class ClassNameUpgradeProcess
extends UpgradeKernelPackage {
    private static final String[][] _MODULE_CLASS_NAMES = new String[][]{{"com.liferay.portlet.dynamicdatamapping.model.", "com.liferay.dynamic.data.mapping.model."}, {"com.liferay.portlet.dynamicdatalists.model.", "com.liferay.dynamic.data.lists.model."}, {"com.liferay.portlet.journal.model.", "com.liferay.journal.model."}, {"com.liferay.portlet.wiki.model.", "com.liferay.wiki.model."}};
    private final ClassNameLocalService _classNameLocalService;

    public ClassNameUpgradeProcess(ClassNameLocalService classNameLocalService) {
        this._classNameLocalService = classNameLocalService;
    }

    protected void doUpgrade() throws UpgradeException {
        try {
            this.upgradeClassNames();
            this.upgradeClassNameColumns();
        }
        catch (Exception e) {
            throw new UpgradeException((Throwable)e);
        }
    }

    protected long getClassNameId(String value) {
        ClassName className = this._classNameLocalService.fetchClassName(value);
        if (className.getClassNameId() > 0L) {
            return className.getClassNameId();
        }
        for (String[] classNameReplacement : _MODULE_CLASS_NAMES) {
            if (!value.startsWith(classNameReplacement[0])) continue;
            String replacedValue = value.replaceFirst(classNameReplacement[0], classNameReplacement[1]);
            className = this._classNameLocalService.fetchClassName(replacedValue);
            return className.getClassNameId();
        }
        return 0L;
    }

    protected String[][] getClassNames() {
        Object[][] kernelClassNames = super.getClassNames();
        return (String[][])ArrayUtil.append((Object[][])kernelClassNames, (Object[][])_MODULE_CLASS_NAMES);
    }

    protected abstract void upgradeClassNameColumns() throws Exception;

    protected abstract void upgradeClassNames() throws Exception;
}

