/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.content.targeting.display.context;

import com.liferay.content.targeting.analytics.configuration.AnalyticsStorageConfiguration;
import com.liferay.content.targeting.api.model.Report;
import com.liferay.content.targeting.api.model.ReportsRegistry;
import com.liferay.content.targeting.display.context.BaseDisplayContext;
import com.liferay.content.targeting.model.Campaign;
import com.liferay.content.targeting.model.ReportInstance;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class BaseReportDisplayContext
extends BaseDisplayContext {
    public static final int DEFAULT_DELTA = 20;
    private String _className;
    private Long _classNameId;
    private Long _classPK;
    private String _name;
    private String _redirect;
    private Report _report;
    private ReportInstance _reportInstance;
    private Long _reportInstanceId;
    private ReportsRegistry _reportsRegistry;

    public BaseReportDisplayContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        super(liferayPortletRequest, liferayPortletResponse);
    }

    public String getBackURL() {
        String backURL = ParamUtil.getString((HttpServletRequest)this.request, (String)"backURL");
        if (Validator.isNotNull((String)backURL)) {
            return backURL;
        }
        PortletURL backURLObject = this.liferayPortletResponse.createRenderURL();
        backURLObject.setParameter("mvcPath", "/view_reports.jsp");
        backURLObject.setParameter("classNameId", String.valueOf(this.getClassNameId()));
        backURLObject.setParameter("classPK", String.valueOf(this.getClassPK()));
        if (this.getClassName().equals(Campaign.class.getName())) {
            backURLObject.setParameter("campaignId", String.valueOf(this.getClassPK()));
        } else {
            backURLObject.setParameter("userSegmentId", String.valueOf(this.getClassPK()));
        }
        return backURLObject.toString();
    }

    public String getClassName() {
        if (this._className != null) {
            return this._className;
        }
        this._className = GetterUtil.getString(this.context.get("className"));
        return this._className;
    }

    public long getClassNameId() {
        if (this._classNameId != null) {
            return this._classNameId;
        }
        this._classNameId = GetterUtil.getLong(this.context.get("classNameId"));
        return this._classNameId;
    }

    public long getClassPK() {
        if (this._classPK != null) {
            return this._classPK;
        }
        this._classPK = GetterUtil.getLong(this.context.get("classPK"));
        return this._classPK;
    }

    public String getName() {
        if (this._name != null) {
            return this._name;
        }
        this._name = GetterUtil.getString(this.context.get("name"));
        return this._name;
    }

    public String getRedirect() {
        if (this._redirect != null) {
            return this._redirect;
        }
        this._redirect = GetterUtil.getString(this.context.get("redirect"));
        return this._redirect;
    }

    public Report getReport() {
        if (this._report != null) {
            return this._report;
        }
        this._report = (Report)this.context.get("report");
        if (this._report == null) {
            String reportKey = GetterUtil.getString(this.context.get("reportKey"));
            this._report = this.getReportsRegistry().getReport(reportKey);
        }
        return this._report;
    }

    public ReportInstance getReportInstance() {
        if (this._reportInstance != null) {
            return this._reportInstance;
        }
        this._reportInstance = (ReportInstance)this.context.get("reportInstance");
        return this._reportInstance;
    }

    public long getReportInstanceId() {
        if (this._reportInstanceId != null) {
            return this._reportInstanceId;
        }
        this._reportInstanceId = GetterUtil.getLong(this.context.get("reportInstanceId"));
        return this._reportInstanceId;
    }

    public ReportsRegistry getReportsRegistry() {
        if (this._reportsRegistry != null) {
            return this._reportsRegistry;
        }
        this._reportsRegistry = (ReportsRegistry)this.context.get("reportsRegistry");
        return this._reportsRegistry;
    }

    public boolean isAnalyticsStorageEnabled() {
        AnalyticsStorageConfiguration analyticsStorageConfiguration = (AnalyticsStorageConfiguration)this.request.getAttribute("analyticsStorageConfiguration");
        if (analyticsStorageConfiguration != null) {
            return analyticsStorageConfiguration.storageEnabled();
        }
        return true;
    }

    protected PortletURL getPortletURL() {
        Report report = this.getReport();
        PortletURL portletURL = this.liferayPortletResponse.createRenderURL();
        portletURL.setParameter("mvcRenderCommandName", "viewReport");
        portletURL.setParameter("redirect", this.getRedirect());
        portletURL.setParameter("reportKey", report.getReportKey());
        portletURL.setParameter("classNameId", String.valueOf(this.getClassNameId()));
        portletURL.setParameter("classPK", String.valueOf(this.getClassPK()));
        portletURL.setParameter("reportInstanceId", String.valueOf(this.getReportInstanceId()));
        return portletURL;
    }
}

