/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.content.targeting.display.context;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class BaseDisplayContext {
    protected final Map<String, Object> context;
    protected final LiferayPortletRequest liferayPortletRequest;
    protected final LiferayPortletResponse liferayPortletResponse;
    protected final HttpServletRequest request;
    private static final Log _log = LogFactoryUtil.getLog(BaseDisplayContext.class);

    public BaseDisplayContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        this.liferayPortletRequest = liferayPortletRequest;
        this.liferayPortletResponse = liferayPortletResponse;
        this.request = PortalUtil.getHttpServletRequest((PortletRequest)liferayPortletRequest);
        this.context = (Map)this.request.getAttribute("context");
    }

    public PortletURL getControlPanelURL(String portletId) {
        if (!this.hasControlPanelAccessPermission(portletId)) {
            return null;
        }
        return PortalUtil.getControlPanelPortletURL((HttpServletRequest)this.request, (String)portletId, (String)"RENDER_PHASE");
    }

    public String getPortalSettingsURL() {
        PortletURL portletURL = this.getControlPanelURL("com_liferay_portal_settings_web_portlet_PortalSettingsPortlet");
        return portletURL.toString();
    }

    public String getSiteSettingsURL() {
        PortletURL portletURL = this.getControlPanelURL("com_liferay_site_admin_web_portlet_SiteSettingsPortlet");
        return portletURL.toString();
    }

    protected boolean hasControlPanelAccessPermission(String portletId) {
        block3: {
            ThemeDisplay themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            try {
                if (PortletPermissionUtil.hasControlPanelAccessPermission((PermissionChecker)themeDisplay.getPermissionChecker(), (long)themeDisplay.getScopeGroupId(), (String)portletId)) {
                    return true;
                }
            }
            catch (PortalException pe) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)pe, (Throwable)pe);
            }
        }
        return false;
    }
}

