/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.content.targeting.api.model;

import com.liferay.content.targeting.anonymous.users.model.AnonymousUser;
import com.liferay.content.targeting.api.model.Rule;
import com.liferay.content.targeting.model.RuleInstance;
import com.liferay.content.targeting.model.UserSegment;
import com.liferay.content.targeting.util.ContentTargetingUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.xml.Element;
import java.util.Locale;
import java.util.Map;

public abstract class BaseRule
implements Rule {
    private static final Log _log = LogFactoryUtil.getLog(BaseRule.class);

    @Override
    public void activate() {
        Class<?> clazz = this.getClass();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Rule activate: " + clazz.getSimpleName()));
        }
    }

    @Override
    public void deActivate() {
        Class<?> clazz = this.getClass();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Rule deactivate: " + clazz.getSimpleName()));
        }
    }

    @Override
    public void deleteData(RuleInstance ruleInstance) throws PortalException {
    }

    @Override
    public boolean evaluate(Map<String, Object> context, RuleInstance ruleInstance, AnonymousUser anonymousUser) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exportData(PortletDataContext portletDataContext, Element userSegmentElement, UserSegment userSegment, Element ruleInstanceElement, RuleInstance ruleInstance) throws Exception {
    }

    @Override
    public long getCacheTime() {
        return 0L;
    }

    @Override
    public String getDescription(Locale locale) {
        return ContentTargetingUtil.getDescription(this.getClass(), locale);
    }

    @Override
    public String getIcon() {
        return "icon-retweet";
    }

    @Override
    public String getName(Locale locale) {
        return ContentTargetingUtil.getName(this.getClass(), locale);
    }

    @Override
    public String getRuleCategoryKey() {
        return "";
    }

    @Override
    public String getRuleKey() {
        Class<?> clazz = this.getClass();
        return clazz.getSimpleName();
    }

    @Override
    public String getShortDescription(Locale locale) {
        return ContentTargetingUtil.getShortDescription(this.getClass(), locale);
    }

    @Override
    public void importData(PortletDataContext portletDataContext, UserSegment userSegment, RuleInstance ruleInstance) throws Exception {
    }

    @Override
    public boolean isInstantiable() {
        return false;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public boolean supportsOfflineEvaluation() {
        return false;
    }

    protected String getExportImportErrorMessage(UserSegment userSegment, RuleInstance ruleInstance, String missingReferenceClassName, String missingReferenceId, String action) {
        StringBundler sb = new StringBundler(9);
        if (action.equals("export")) {
            sb.append("Cannot export rule ");
        } else {
            sb.append("Cannot import rule ");
        }
        sb.append(this.getName(LocaleUtil.getDefault()));
        sb.append(" from user segment ");
        sb.append(userSegment.getName(LocaleUtil.getDefault()));
        sb.append(" because it refers to a missing ");
        sb.append(ResourceActionsUtil.getModelResource((Locale)LocaleUtil.getDefault(), (String)missingReferenceClassName));
        sb.append(" with id ");
        sb.append(missingReferenceId);
        sb.append(".");
        return sb.toString();
    }
}

