/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.content.targeting.api.model;

import com.liferay.content.targeting.api.model.BaseReport;
import com.liferay.content.targeting.model.ReportInstance;
import com.liferay.content.targeting.util.ContentTargetingContextUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.Map;

public abstract class BaseFreemarkerReport
extends BaseReport {
    private static final String _EDIT_FORM_TEMPLATE_PATH = "templates/edit.ftl";
    private static final String _FORM_TEMPLATE_PATH = "templates/view.ftl";
    private static final Log _log = LogFactoryUtil.getLog(BaseFreemarkerReport.class);

    @Override
    public String getEditHTML(ReportInstance reportInstance, Map<String, Object> context) {
        String content = "";
        try {
            this.populateEditContext(reportInstance, context);
            content = ContentTargetingContextUtil.parseTemplate(this.getClass(), this.getEditFormTemplatePath(), context);
        }
        catch (Exception e) {
            _log.error((Object)("Error while processing edit report form template " + this.getEditFormTemplatePath()), (Throwable)e);
        }
        return content;
    }

    @Override
    public String getHTML(ReportInstance reportInstance, Map<String, Object> context) {
        String content = "";
        try {
            this.populateContext(reportInstance, context);
            content = ContentTargetingContextUtil.parseTemplate(this.getClass(), this.getFormTemplatePath(), context);
        }
        catch (Exception e) {
            _log.error((Object)("Error while processing report form template " + this.getFormTemplatePath()), (Throwable)e);
        }
        return content;
    }

    protected String getEditFormTemplatePath() {
        return _EDIT_FORM_TEMPLATE_PATH;
    }

    protected String getFormTemplatePath() {
        return _FORM_TEMPLATE_PATH;
    }

    protected void populateContext(ReportInstance reportInstance, Map<String, Object> context) {
    }

    protected void populateEditContext(ReportInstance reportInstance, Map<String, Object> context) {
    }
}

