/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.content.targeting.util;

import com.liferay.petra.lang.CentralizedThreadLocal;

/**
 * @author Eduardo Garcia
 */
public class ContentTargetingThreadLocal {

	public static long[] getUserSegmentIds() {
		return _userSegmentIds.get();
	}

	public static void setUserSegmentIds(long[] userSegmentIds) {
		_userSegmentIds.set(userSegmentIds);
	}

	private static final ThreadLocal<long[]> _userSegmentIds =
		new CentralizedThreadLocal<>(
			ContentTargetingThreadLocal.class + "._userSegmentIds",
			() -> new long[0]);

}