/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.content.targeting.upgrade.classname;

import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.upgrade.v7_0_0.UpgradeKernelPackage;

/**
 * @author Eduardo Garcia
 */
public abstract class ClassNameUpgradeProcess extends UpgradeKernelPackage {

	public ClassNameUpgradeProcess(
		ClassNameLocalService classNameLocalService) {

		_classNameLocalService = classNameLocalService;
	}

	@Override
	protected void doUpgrade() throws UpgradeException {
		try {
			upgradeClassNames();
			upgradeClassNameColumns();
		}
		catch (Exception e) {
			throw new UpgradeException(e);
		}
	}

	protected long getClassNameId(String value) {
		ClassName className = _classNameLocalService.fetchClassName(value);

		if (className.getClassNameId() > 0) {
			return className.getClassNameId();
		}

		for (String[] classNameReplacement : _MODULE_CLASS_NAMES) {
			if (value.startsWith(classNameReplacement[0])) {
				String replacedValue = value.replaceFirst(
					classNameReplacement[0], classNameReplacement[1]);

				className = _classNameLocalService.fetchClassName(
					replacedValue);

				return className.getClassNameId();
			}
		}

		return 0;
	}

	@Override
	protected String[][] getClassNames() {
		String[][] kernelClassNames = super.getClassNames();

		return ArrayUtil.append(kernelClassNames, _MODULE_CLASS_NAMES);
	}

	protected abstract void upgradeClassNameColumns() throws Exception;

	protected abstract void upgradeClassNames() throws Exception;

	private static final String[][] _MODULE_CLASS_NAMES = {
		{
			"com.liferay.portlet.dynamicdatamapping.model.",
			"com.liferay.dynamic.data.mapping.model."
		},
		{
			"com.liferay.portlet.dynamicdatalists.model.",
			"com.liferay.dynamic.data.lists.model."
		},
		{"com.liferay.portlet.journal.model.", "com.liferay.journal.model."},
		{"com.liferay.portlet.wiki.model.", "com.liferay.wiki.model."}
	};

	private final ClassNameLocalService _classNameLocalService;

}