/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.content.targeting.model;

import aQute.bnd.annotation.ProviderType;

import com.liferay.expando.kernel.model.ExpandoBridge;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedAuditedModel;
import com.liferay.portal.kernel.service.ServiceContext;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the ChannelInstance service. Represents a row in the &quot;CT_ChannelInstance&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link com.liferay.content.targeting.model.impl.ChannelInstanceModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link com.liferay.content.targeting.model.impl.ChannelInstanceImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see ChannelInstance
 * @see com.liferay.content.targeting.model.impl.ChannelInstanceImpl
 * @see com.liferay.content.targeting.model.impl.ChannelInstanceModelImpl
 * @generated
 */
@ProviderType
public interface ChannelInstanceModel extends BaseModel<ChannelInstance>,
	GroupedModel, ShardedModel, StagedAuditedModel {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a channel instance model instance should use the {@link ChannelInstance} interface instead.
	 */

	/**
	 * Returns the primary key of this channel instance.
	 *
	 * @return the primary key of this channel instance
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this channel instance.
	 *
	 * @param primaryKey the primary key of this channel instance
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the uuid of this channel instance.
	 *
	 * @return the uuid of this channel instance
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this channel instance.
	 *
	 * @param uuid the uuid of this channel instance
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the channel instance ID of this channel instance.
	 *
	 * @return the channel instance ID of this channel instance
	 */
	public long getChannelInstanceId();

	/**
	 * Sets the channel instance ID of this channel instance.
	 *
	 * @param channelInstanceId the channel instance ID of this channel instance
	 */
	public void setChannelInstanceId(long channelInstanceId);

	/**
	 * Returns the group ID of this channel instance.
	 *
	 * @return the group ID of this channel instance
	 */
	@Override
	public long getGroupId();

	/**
	 * Sets the group ID of this channel instance.
	 *
	 * @param groupId the group ID of this channel instance
	 */
	@Override
	public void setGroupId(long groupId);

	/**
	 * Returns the company ID of this channel instance.
	 *
	 * @return the company ID of this channel instance
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this channel instance.
	 *
	 * @param companyId the company ID of this channel instance
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this channel instance.
	 *
	 * @return the user ID of this channel instance
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this channel instance.
	 *
	 * @param userId the user ID of this channel instance
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this channel instance.
	 *
	 * @return the user uuid of this channel instance
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this channel instance.
	 *
	 * @param userUuid the user uuid of this channel instance
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this channel instance.
	 *
	 * @return the user name of this channel instance
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this channel instance.
	 *
	 * @param userName the user name of this channel instance
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this channel instance.
	 *
	 * @return the create date of this channel instance
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this channel instance.
	 *
	 * @param createDate the create date of this channel instance
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this channel instance.
	 *
	 * @return the modified date of this channel instance
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this channel instance.
	 *
	 * @param modifiedDate the modified date of this channel instance
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the channel key of this channel instance.
	 *
	 * @return the channel key of this channel instance
	 */
	@AutoEscape
	public String getChannelKey();

	/**
	 * Sets the channel key of this channel instance.
	 *
	 * @param channelKey the channel key of this channel instance
	 */
	public void setChannelKey(String channelKey);

	/**
	 * Returns the campaign ID of this channel instance.
	 *
	 * @return the campaign ID of this channel instance
	 */
	public long getCampaignId();

	/**
	 * Sets the campaign ID of this channel instance.
	 *
	 * @param campaignId the campaign ID of this channel instance
	 */
	public void setCampaignId(long campaignId);

	/**
	 * Returns the tactic ID of this channel instance.
	 *
	 * @return the tactic ID of this channel instance
	 */
	public long getTacticId();

	/**
	 * Sets the tactic ID of this channel instance.
	 *
	 * @param tacticId the tactic ID of this channel instance
	 */
	public void setTacticId(long tacticId);

	/**
	 * Returns the alias of this channel instance.
	 *
	 * @return the alias of this channel instance
	 */
	@AutoEscape
	public String getAlias();

	/**
	 * Sets the alias of this channel instance.
	 *
	 * @param alias the alias of this channel instance
	 */
	public void setAlias(String alias);

	/**
	 * Returns the type settings of this channel instance.
	 *
	 * @return the type settings of this channel instance
	 */
	@AutoEscape
	public String getTypeSettings();

	/**
	 * Sets the type settings of this channel instance.
	 *
	 * @param typeSettings the type settings of this channel instance
	 */
	public void setTypeSettings(String typeSettings);

	@Override
	public boolean isNew();

	@Override
	public void setNew(boolean n);

	@Override
	public boolean isCachedModel();

	@Override
	public void setCachedModel(boolean cachedModel);

	@Override
	public boolean isEscapedModel();

	@Override
	public Serializable getPrimaryKeyObj();

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj);

	@Override
	public ExpandoBridge getExpandoBridge();

	@Override
	public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

	@Override
	public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext);

	@Override
	public Object clone();

	@Override
	public int compareTo(ChannelInstance channelInstance);

	@Override
	public int hashCode();

	@Override
	public CacheModel<ChannelInstance> toCacheModel();

	@Override
	public ChannelInstance toEscapedModel();

	@Override
	public ChannelInstance toUnescapedModel();

	@Override
	public String toString();

	@Override
	public String toXmlString();
}