/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.content.targeting.display.context;

import com.liferay.content.targeting.analytics.configuration.AnalyticsStorageConfiguration;
import com.liferay.content.targeting.api.model.Report;
import com.liferay.content.targeting.api.model.ReportsRegistry;
import com.liferay.content.targeting.model.Campaign;
import com.liferay.content.targeting.model.ReportInstance;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;

import javax.portlet.PortletURL;

/**
 * @author Pavel Savinov
 */
public class BaseReportDisplayContext extends BaseDisplayContext {

	public static final int DEFAULT_DELTA = 20;

	public BaseReportDisplayContext(
		LiferayPortletRequest liferayPortletRequest,
		LiferayPortletResponse liferayPortletResponse) {

		super(liferayPortletRequest, liferayPortletResponse);
	}

	public String getBackURL() {
		String backURL = ParamUtil.getString(request, "backURL");

		if (Validator.isNotNull(backURL)) {
			return backURL;
		}

		PortletURL backURLObject = liferayPortletResponse.createRenderURL();

		backURLObject.setParameter("mvcPath", "/view_reports.jsp");
		backURLObject.setParameter(
			"classNameId", String.valueOf(getClassNameId()));
		backURLObject.setParameter("classPK", String.valueOf(getClassPK()));

		if (getClassName().equals(Campaign.class.getName())) {
			backURLObject.setParameter(
				"campaignId", String.valueOf(getClassPK()));
		}
		else {
			backURLObject.setParameter(
				"userSegmentId", String.valueOf(getClassPK()));
		}

		return backURLObject.toString();
	}

	public String getClassName() {
		if (_className != null) {
			return _className;
		}

		_className = GetterUtil.getString(context.get("className"));

		return _className;
	}

	public long getClassNameId() {
		if (_classNameId != null) {
			return _classNameId;
		}

		_classNameId = GetterUtil.getLong(context.get("classNameId"));

		return _classNameId;
	}

	public long getClassPK() {
		if (_classPK != null) {
			return _classPK;
		}

		_classPK = GetterUtil.getLong(context.get("classPK"));

		return _classPK;
	}

	public String getName() {
		if (_name != null) {
			return _name;
		}

		_name = GetterUtil.getString(context.get("name"));

		return _name;
	}

	public String getRedirect() {
		if (_redirect != null) {
			return _redirect;
		}

		_redirect = GetterUtil.getString(context.get("redirect"));

		return _redirect;
	}

	public Report getReport() {
		if (_report != null) {
			return _report;
		}

		_report = (Report)context.get("report");

		if (_report == null) {
			String reportKey = GetterUtil.getString(context.get("reportKey"));

			_report = getReportsRegistry().getReport(reportKey);
		}

		return _report;
	}

	public ReportInstance getReportInstance() {
		if (_reportInstance != null) {
			return _reportInstance;
		}

		_reportInstance = (ReportInstance)context.get("reportInstance");

		return _reportInstance;
	}

	public long getReportInstanceId() {
		if (_reportInstanceId != null) {
			return _reportInstanceId;
		}

		_reportInstanceId = GetterUtil.getLong(context.get("reportInstanceId"));

		return _reportInstanceId;
	}

	public ReportsRegistry getReportsRegistry() {
		if (_reportsRegistry != null) {
			return _reportsRegistry;
		}

		_reportsRegistry = (ReportsRegistry)context.get("reportsRegistry");

		return _reportsRegistry;
	}

	public boolean isAnalyticsStorageEnabled() {
		AnalyticsStorageConfiguration analyticsStorageConfiguration =
			(AnalyticsStorageConfiguration)request.getAttribute(
				"analyticsStorageConfiguration");

		if (analyticsStorageConfiguration != null) {
			return analyticsStorageConfiguration.storageEnabled();
		}

		return true;
	}

	protected PortletURL getPortletURL() {
		Report report = getReport();

		PortletURL portletURL = liferayPortletResponse.createRenderURL();

		portletURL.setParameter("mvcRenderCommandName", "viewReport");
		portletURL.setParameter("redirect", getRedirect());
		portletURL.setParameter("reportKey", report.getReportKey());
		portletURL.setParameter(
			"classNameId", String.valueOf(getClassNameId()));
		portletURL.setParameter("classPK", String.valueOf(getClassPK()));
		portletURL.setParameter(
			"reportInstanceId", String.valueOf(getReportInstanceId()));

		return portletURL;
	}

	private String _className;
	private Long _classNameId;
	private Long _classPK;
	private String _name;
	private String _redirect;
	private Report _report;
	private ReportInstance _reportInstance;
	private Long _reportInstanceId;
	private ReportsRegistry _reportsRegistry;

}