/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.machine.learning.internal.resource.v1_0;

import com.liferay.commerce.machine.learning.forecast.CommerceAccountCommerceMLForecast;
import com.liferay.commerce.machine.learning.forecast.CommerceAccountCommerceMLForecastManager;
import com.liferay.headless.commerce.machine.learning.dto.v1_0.AccountForecast;
import com.liferay.headless.commerce.machine.learning.internal.dto.v1_0.converter.CommerceMLForecastCompositeResourcePrimaryKey;
import com.liferay.headless.commerce.machine.learning.internal.helper.v1_0.CommerceAccountPermissionHelper;
import com.liferay.headless.commerce.machine.learning.internal.resource.v1_0.BaseAccountForecastResourceImpl;
import com.liferay.headless.commerce.machine.learning.resource.v1_0.AccountForecastResource;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/account-forecast.properties"}, scope=ServiceScope.PROTOTYPE, service={AccountForecastResource.class})
public class AccountForecastResourceImpl
extends BaseAccountForecastResourceImpl {
    @Reference(target="(component.name=com.liferay.headless.commerce.machine.learning.internal.dto.v1_0.converter.AccountForecastDTOConverter)")
    private DTOConverter<CommerceAccountCommerceMLForecast, AccountForecast> _accountForecastDTOConverter;
    @Reference
    private CommerceAccountCommerceMLForecastManager _commerceAccountCommerceMLForecastManager;
    @Reference
    private CommerceAccountPermissionHelper _commerceAccountPermissionHelper;

    @Override
    public void create(Collection<AccountForecast> accountForecasts, Map<String, Serializable> parameters) throws Exception {
        this.contextBatchUnsafeBiConsumer.accept(accountForecasts, accountForecast -> {
            CommerceAccountCommerceMLForecast commerceAccountCommerceMLForecast = this._commerceAccountCommerceMLForecastManager.create();
            if (accountForecast.getActual() != null) {
                commerceAccountCommerceMLForecast.setActual(accountForecast.getActual().floatValue());
            }
            commerceAccountCommerceMLForecast.setCommerceAccountId(accountForecast.getAccount().longValue());
            commerceAccountCommerceMLForecast.setCompanyId(this.contextCompany.getCompanyId());
            commerceAccountCommerceMLForecast.setForecast(accountForecast.getForecast().floatValue());
            commerceAccountCommerceMLForecast.setForecastLowerBound(accountForecast.getForecastLowerBound().floatValue());
            commerceAccountCommerceMLForecast.setForecastUpperBound(accountForecast.getForecastUpperBound().floatValue());
            commerceAccountCommerceMLForecast.setPeriod("month");
            commerceAccountCommerceMLForecast.setScope("commerce-account");
            commerceAccountCommerceMLForecast.setTarget("revenue");
            commerceAccountCommerceMLForecast.setTimestamp(accountForecast.getTimestamp());
            this._commerceAccountCommerceMLForecastManager.addCommerceAccountCommerceMLForecast(commerceAccountCommerceMLForecast);
            return null;
        });
    }

    @Override
    public Page<AccountForecast> getAccountForecastsByMonthlyRevenuePage(Long[] accountIds, Integer forecastLength, Date forecastStartDate, Integer historyLength, Pagination pagination) throws Exception {
        List<Long> commerceAccountIds = this._commerceAccountPermissionHelper.filterCommerceAccountIds(Arrays.asList(accountIds));
        if (commerceAccountIds.isEmpty()) {
            return Page.of(Collections.emptyList());
        }
        Date startDate = forecastStartDate;
        if (startDate == null) {
            startDate = new Date();
        }
        if (historyLength == null) {
            historyLength = 8;
        }
        if (forecastLength == null) {
            forecastLength = 3;
        }
        return Page.of(this.transform(this._commerceAccountCommerceMLForecastManager.getMonthlyRevenueCommerceAccountCommerceMLForecasts(this.contextCompany.getCompanyId(), ArrayUtil.toLongArray(commerceAccountIds), startDate, historyLength.intValue(), forecastLength.intValue(), pagination.getStartPosition(), pagination.getEndPosition()), commerceAccountCommerceMLForecast -> (AccountForecast)this._accountForecastDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)new CommerceMLForecastCompositeResourcePrimaryKey(commerceAccountCommerceMLForecast.getCompanyId(), commerceAccountCommerceMLForecast.getForecastId()), this.contextAcceptLanguage.getPreferredLocale()))), (Pagination)pagination, (long)this._commerceAccountCommerceMLForecastManager.getMonthlyRevenueCommerceAccountCommerceMLForecastsCount(this.contextCompany.getCompanyId(), ArrayUtil.toLongArray(commerceAccountIds), startDate, historyLength.intValue(), forecastLength.intValue()));
    }
}

