/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.machine.learning.internal.resource.v1_0;

import com.liferay.commerce.machine.learning.forecast.AssetCategoryCommerceMLForecast;
import com.liferay.commerce.machine.learning.forecast.AssetCategoryCommerceMLForecastManager;
import com.liferay.headless.commerce.machine.learning.dto.v1_0.AccountCategoryForecast;
import com.liferay.headless.commerce.machine.learning.internal.dto.v1_0.converter.CommerceMLForecastCompositeResourcePrimaryKey;
import com.liferay.headless.commerce.machine.learning.internal.helper.v1_0.CommerceAccountPermissionHelper;
import com.liferay.headless.commerce.machine.learning.internal.resource.v1_0.BaseAccountCategoryForecastResourceImpl;
import com.liferay.headless.commerce.machine.learning.resource.v1_0.AccountCategoryForecastResource;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/account-category-forecast.properties"}, scope=ServiceScope.PROTOTYPE, service={AccountCategoryForecastResource.class})
public class AccountCategoryForecastResourceImpl
extends BaseAccountCategoryForecastResourceImpl {
    @Reference(target="(component.name=com.liferay.headless.commerce.machine.learning.internal.dto.v1_0.converter.AccountCategoryForecastDTOConverter)")
    private DTOConverter<AssetCategoryCommerceMLForecast, AccountCategoryForecast> _accountCategoryForecastDTOConverter;
    @Reference
    private AssetCategoryCommerceMLForecastManager _assetCategoryCommerceMLForecastManager;
    @Reference
    private CommerceAccountPermissionHelper _commerceAccountPermissionHelper;

    @Override
    public void create(Collection<AccountCategoryForecast> accountCategoryForecasts, Map<String, Serializable> parameters) throws Exception {
        this.contextBatchUnsafeBiConsumer.accept(accountCategoryForecasts, accountCategoryForecast -> {
            AssetCategoryCommerceMLForecast assetCategoryCommerceMLForecast = this._assetCategoryCommerceMLForecastManager.create();
            if (accountCategoryForecast.getActual() != null) {
                assetCategoryCommerceMLForecast.setActual(accountCategoryForecast.getActual().floatValue());
            }
            assetCategoryCommerceMLForecast.setAssetCategoryId(accountCategoryForecast.getCategory().longValue());
            assetCategoryCommerceMLForecast.setCommerceAccountId(accountCategoryForecast.getAccount().longValue());
            assetCategoryCommerceMLForecast.setCompanyId(this.contextCompany.getCompanyId());
            assetCategoryCommerceMLForecast.setForecast(accountCategoryForecast.getForecast().floatValue());
            assetCategoryCommerceMLForecast.setForecastLowerBound(accountCategoryForecast.getForecastLowerBound().floatValue());
            assetCategoryCommerceMLForecast.setForecastUpperBound(accountCategoryForecast.getForecastUpperBound().floatValue());
            assetCategoryCommerceMLForecast.setPeriod("month");
            assetCategoryCommerceMLForecast.setScope("asset-category");
            assetCategoryCommerceMLForecast.setTarget("revenue");
            assetCategoryCommerceMLForecast.setTimestamp(accountCategoryForecast.getTimestamp());
            this._assetCategoryCommerceMLForecastManager.addAssetCategoryCommerceMLForecast(assetCategoryCommerceMLForecast);
            return null;
        });
    }

    @Override
    public Page<AccountCategoryForecast> getAccountCategoryForecastsByMonthlyRevenuePage(Long[] accountIds, Long[] categoryIds, Integer forecastLength, Date forecastStartDate, Integer historyLength, Pagination pagination) throws Exception {
        List<Long> commerceAccountIds = this._commerceAccountPermissionHelper.filterCommerceAccountIds(Arrays.asList(accountIds));
        if (commerceAccountIds.isEmpty()) {
            return Page.of(Collections.emptyList());
        }
        Date startDate = forecastStartDate;
        if (startDate == null) {
            startDate = new Date();
        }
        if (historyLength == null) {
            historyLength = 8;
        }
        if (forecastLength == null) {
            forecastLength = 3;
        }
        return Page.of(this.transform(this._assetCategoryCommerceMLForecastManager.getMonthlyRevenueAssetCategoryCommerceMLForecasts(this.contextCompany.getCompanyId(), ArrayUtil.toArray((Long[])categoryIds), ArrayUtil.toLongArray(commerceAccountIds), startDate, historyLength.intValue(), forecastLength.intValue(), pagination.getStartPosition(), pagination.getEndPosition()), assetCategoryCommerceMLForecast -> (AccountCategoryForecast)this._accountCategoryForecastDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)new CommerceMLForecastCompositeResourcePrimaryKey(assetCategoryCommerceMLForecast.getCompanyId(), assetCategoryCommerceMLForecast.getForecastId()), this.contextAcceptLanguage.getPreferredLocale()))), (Pagination)pagination, (long)this._assetCategoryCommerceMLForecastManager.getMonthlyRevenueAssetCategoryCommerceMLForecastsCount(this.contextCompany.getCompanyId(), ArrayUtil.toArray((Long[])categoryIds), ArrayUtil.toLongArray(commerceAccountIds), startDate, historyLength.intValue(), forecastLength.intValue()));
    }
}

