/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.machine.learning.internal.dto.v1_0.converter;

import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.headless.commerce.machine.learning.dto.v1_0.Sku;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.product.model.CPInstance"}, service={DTOConverter.class})
public class SkuDTOConverter
implements DTOConverter<CPInstance, Sku> {
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;

    public String getContentType() {
        return Sku.class.getSimpleName();
    }

    public CPInstance getObject(String externalReferenceCode) throws Exception {
        return this._cpInstanceLocalService.fetchCPInstance(GetterUtil.getLong((String)externalReferenceCode));
    }

    public Sku toDTO(DTOConverterContext dtoConverterContext, final CPInstance cpInstance) throws Exception {
        if (cpInstance == null) {
            return null;
        }
        return new Sku(){
            {
                this.setCost(() -> ((CPInstance)cpInstance).getCost());
                this.setDiscontinued(() -> ((CPInstance)cpInstance).isDiscontinued());
                this.setDisplayDate(() -> ((CPInstance)cpInstance).getDisplayDate());
                this.setExpirationDate(() -> ((CPInstance)cpInstance).getExpirationDate());
                this.setExternalReferenceCode(() -> ((CPInstance)cpInstance).getExternalReferenceCode());
                this.setGtin(() -> ((CPInstance)cpInstance).getGtin());
                this.setId(() -> ((CPInstance)cpInstance).getCPInstanceId());
                this.setManufacturerPartNumber(() -> ((CPInstance)cpInstance).getManufacturerPartNumber());
                this.setPublished(() -> ((CPInstance)cpInstance).isPublished());
                this.setPurchasable(() -> ((CPInstance)cpInstance).isPurchasable());
                this.setSku(() -> ((CPInstance)cpInstance).getSku());
            }
        };
    }
}

