/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.machine.learning.internal.dto.v1_0.converter;

import com.liferay.asset.kernel.model.AssetCategoryModel;
import com.liferay.asset.kernel.model.AssetTagModel;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPDefinitionOptionRel;
import com.liferay.commerce.product.model.CPDefinitionSpecificationOptionValue;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CommerceChannelRelLocalService;
import com.liferay.commerce.product.type.CPType;
import com.liferay.commerce.product.type.CPTypeRegistry;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.headless.commerce.machine.learning.dto.v1_0.Product;
import com.liferay.headless.commerce.machine.learning.dto.v1_0.ProductOption;
import com.liferay.headless.commerce.machine.learning.dto.v1_0.ProductSpecification;
import com.liferay.headless.commerce.machine.learning.dto.v1_0.Sku;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.Collection;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.product.model.CPDefinition"}, service={DTOConverter.class})
public class ProductDTOConverter
implements DTOConverter<CPDefinition, Product> {
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private CommerceChannelRelLocalService _commerceChannelRelLocalService;
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @Reference
    private CPTypeRegistry _cpTypeRegistry;
    @Reference(target="(component.name=com.liferay.headless.commerce.machine.learning.internal.dto.v1_0.converter.ProductOptionDTOConverter)")
    private DTOConverter<CPDefinitionOptionRel, ProductOption> _productOptionDTOConverter;
    @Reference(target="(component.name=com.liferay.headless.commerce.machine.learning.internal.dto.v1_0.converter.ProductSpecificationDTOConverter)")
    private DTOConverter<CPDefinitionSpecificationOptionValue, ProductSpecification> _productSpecificationDTOConverter;
    @Reference(target="(component.name=com.liferay.headless.commerce.machine.learning.internal.dto.v1_0.converter.SkuDTOConverter)")
    private DTOConverter<CPInstance, Sku> _skuDTOConverter;

    public String getContentType() {
        return Product.class.getSimpleName();
    }

    public CPDefinition getObject(String externalReferenceCode) throws Exception {
        return this._cpDefinitionLocalService.fetchCPDefinition(GetterUtil.getLong((String)externalReferenceCode));
    }

    public Product toDTO(DTOConverterContext dtoConverterContext, final CPDefinition cpDefinition) throws Exception {
        if (cpDefinition == null) {
            return null;
        }
        final CProduct cProduct = cpDefinition.getCProduct();
        return new Product(){
            {
                this.setCatalogId(() -> {
                    CommerceCatalog commerceCatalog = cpDefinition.getCommerceCatalog();
                    return commerceCatalog.getCommerceCatalogId();
                });
                this.setCategoryIds(() -> (Long[])TransformUtil.transformToArray((Collection)ProductDTOConverter.this._assetCategoryLocalService.getCategories(cpDefinition.getModelClassName(), cpDefinition.getCPDefinitionId()), AssetCategoryModel::getCategoryId, Long.class));
                this.setCreateDate(() -> ((CPDefinition)cpDefinition).getCreateDate());
                this.setCustomFields(() -> {
                    ExpandoBridge expandoBridge = cpDefinition.getExpandoBridge();
                    return expandoBridge.getAttributes();
                });
                this.setDescription(() -> LanguageUtils.getLanguageIdMap((Map)cpDefinition.getDescriptionMap()));
                this.setDisplayDate(() -> ((CPDefinition)cpDefinition).getDisplayDate());
                this.setExpirationDate(() -> ((CPDefinition)cpDefinition).getExpirationDate());
                this.setExternalReferenceCode(() -> ((CProduct)cProduct).getExternalReferenceCode());
                this.setId(() -> ((CPDefinition)cpDefinition).getCPDefinitionId());
                this.setMetaDescription(() -> LanguageUtils.getLanguageIdMap((Map)cpDefinition.getMetaDescriptionMap()));
                this.setMetaKeyword(() -> LanguageUtils.getLanguageIdMap((Map)cpDefinition.getMetaKeywordsMap()));
                this.setMetaTitle(() -> LanguageUtils.getLanguageIdMap((Map)cpDefinition.getMetaTitleMap()));
                this.setModifiedDate(() -> ((CPDefinition)cpDefinition).getModifiedDate());
                this.setName(() -> LanguageUtils.getLanguageIdMap((Map)cpDefinition.getNameMap()));
                this.setProductChannelIds(() -> (Long[])TransformUtil.transformToArray((Collection)ProductDTOConverter.this._commerceChannelRelLocalService.getCommerceChannelRels(cpDefinition.getModelClassName(), cpDefinition.getCPDefinitionId(), -1, -1, null), commerceChannelRel -> {
                    CommerceChannel commerceChannel = commerceChannelRel.getCommerceChannel();
                    return commerceChannel.getCommerceChannelId();
                }, Long.class));
                this.setProductId(() -> ((CProduct)cProduct).getCProductId());
                this.setProductOptions(() -> (ProductOption[])TransformUtil.transformToArray((Collection)cpDefinition.getCPDefinitionOptionRels(), cpDefinitionOptionRel -> (ProductOption)ProductDTOConverter.this._productOptionDTOConverter.toDTO(cpDefinitionOptionRel), ProductOption.class));
                this.setProductSpecifications(() -> (ProductSpecification[])TransformUtil.transformToArray((Collection)cpDefinition.getCPDefinitionSpecificationOptionValues(), cpDefinitionSpecificationOptionValue -> (ProductSpecification)ProductDTOConverter.this._productSpecificationDTOConverter.toDTO(cpDefinitionSpecificationOptionValue), ProductSpecification.class));
                this.setProductType(() -> {
                    CPType cpType = ProductDTOConverter.this._cpTypeRegistry.getCPType(cpDefinition.getProductTypeName());
                    return cpType.getName();
                });
                this.setSkus(() -> (Sku[])TransformUtil.transformToArray((Collection)cpDefinition.getCPInstances(), cpInstance -> (Sku)ProductDTOConverter.this._skuDTOConverter.toDTO(cpInstance), Sku.class));
                this.setStatus(() -> ((CPDefinition)cpDefinition).getStatus());
                this.setSubscriptionEnabled(() -> ((CPDefinition)cpDefinition).isSubscriptionEnabled());
                this.setTags(() -> (String[])TransformUtil.transformToArray((Collection)ProductDTOConverter.this._assetTagLocalService.getTags(CPDefinition.class.getName(), cpDefinition.getCPDefinitionId()), AssetTagModel::getName, String.class));
                this.setUrls(() -> LanguageUtils.getLanguageIdMap((Map)cpDefinition.getUrlTitleMap()));
            }
        };
    }
}

