/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.machine.learning.internal.dto.v1_0.converter;

import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.product.model.CPMeasurementUnit;
import com.liferay.commerce.product.service.CPMeasurementUnitLocalService;
import com.liferay.commerce.service.CommerceOrderItemLocalService;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.headless.commerce.machine.learning.dto.v1_0.OrderItem;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.math.BigDecimal;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.model.CommerceOrderItem"}, service={DTOConverter.class})
public class OrderItemDTOConverter
implements DTOConverter<CommerceOrderItem, OrderItem> {
    @Reference
    private CommerceOrderItemLocalService _commerceOrderItemLocalService;
    @Reference
    private CPMeasurementUnitLocalService _cpMeasurementUnitLocalService;

    public String getContentType() {
        return OrderItem.class.getSimpleName();
    }

    public CommerceOrderItem getObject(String externalReferenceCode) throws Exception {
        return this._commerceOrderItemLocalService.fetchCommerceOrderItem(GetterUtil.getLong((String)externalReferenceCode));
    }

    public OrderItem toDTO(DTOConverterContext dtoConverterContext, final CommerceOrderItem commerceOrderItem) throws Exception {
        if (commerceOrderItem == null) {
            return null;
        }
        return new OrderItem(){
            {
                this.setCpDefinitionId(() -> ((CommerceOrderItem)commerceOrderItem).getCPDefinitionId());
                this.setCreateDate(() -> ((CommerceOrderItem)commerceOrderItem).getCreateDate());
                this.setCustomFields(() -> {
                    ExpandoBridge expandoBridge = commerceOrderItem.getExpandoBridge();
                    return expandoBridge.getAttributes();
                });
                this.setExternalReferenceCode(() -> ((CommerceOrderItem)commerceOrderItem).getExternalReferenceCode());
                this.setFinalPrice(() -> ((CommerceOrderItem)commerceOrderItem).getFinalPrice());
                this.setId(() -> ((CommerceOrderItem)commerceOrderItem).getCommerceOrderItemId());
                this.setModifiedDate(() -> ((CommerceOrderItem)commerceOrderItem).getModifiedDate());
                this.setName(() -> LanguageUtils.getLanguageIdMap((Map)commerceOrderItem.getNameMap()));
                this.setOptions(() -> ((CommerceOrderItem)commerceOrderItem).getJson());
                this.setParentOrderItemId(() -> ((CommerceOrderItem)commerceOrderItem).getParentCommerceOrderItemId());
                this.setQuantity(() -> {
                    BigDecimal quantity = commerceOrderItem.getQuantity();
                    return quantity.intValue();
                });
                this.setSku(() -> ((CommerceOrderItem)commerceOrderItem).getSku());
                this.setSubscription(() -> ((CommerceOrderItem)commerceOrderItem).isSubscription());
                this.setUnitOfMeasure(() -> {
                    if (commerceOrderItem.getCPMeasurementUnitId() <= 0L) {
                        return "";
                    }
                    CPMeasurementUnit cpMeasurementUnit = OrderItemDTOConverter.this._cpMeasurementUnitLocalService.getCPMeasurementUnit(commerceOrderItem.getCPMeasurementUnitId());
                    return cpMeasurementUnit.getKey();
                });
                this.setUnitPrice(() -> ((CommerceOrderItem)commerceOrderItem).getUnitPrice());
                this.setUserId(() -> ((CommerceOrderItem)commerceOrderItem).getUserId());
            }
        };
    }
}

