/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.machine.learning.internal.dto.v1_0.converter;

import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.headless.commerce.machine.learning.dto.v1_0.Order;
import com.liferay.headless.commerce.machine.learning.dto.v1_0.OrderItem;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.Collection;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.model.CommerceOrder"}, service={DTOConverter.class})
public class OrderDTOConverter
implements DTOConverter<CommerceOrder, Order> {
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;
    @Reference(target="(component.name=com.liferay.headless.commerce.machine.learning.internal.dto.v1_0.converter.OrderItemDTOConverter)")
    private DTOConverter<CommerceOrderItem, OrderItem> _orderItemDTOConverter;

    public String getContentType() {
        return Order.class.getSimpleName();
    }

    public CommerceOrder getObject(String externalReferenceCode) throws Exception {
        return this._commerceOrderLocalService.fetchCommerceOrder(GetterUtil.getLong((String)externalReferenceCode));
    }

    public Order toDTO(DTOConverterContext dtoConverterContext, final CommerceOrder commerceOrder) throws Exception {
        if (commerceOrder == null) {
            return null;
        }
        return new Order(){
            {
                this.setAccountId(() -> ((CommerceOrder)commerceOrder).getCommerceAccountId());
                this.setChannelId(() -> {
                    CommerceChannel commerceChannel = OrderDTOConverter.this._commerceChannelLocalService.fetchCommerceChannelByGroupClassPK(commerceOrder.getGroupId());
                    return commerceChannel.getCommerceChannelId();
                });
                this.setCreateDate(() -> ((CommerceOrder)commerceOrder).getCreateDate());
                this.setCurrencyCode(() -> {
                    CommerceCurrency commerceCurrency = commerceOrder.getCommerceCurrency();
                    return commerceCurrency.getCode();
                });
                this.setCustomFields(() -> {
                    ExpandoBridge expandoBridge = commerceOrder.getExpandoBridge();
                    return expandoBridge.getAttributes();
                });
                this.setExternalReferenceCode(() -> ((CommerceOrder)commerceOrder).getExternalReferenceCode());
                this.setId(() -> ((CommerceOrder)commerceOrder).getCommerceOrderId());
                this.setModifiedDate(() -> ((CommerceOrder)commerceOrder).getModifiedDate());
                this.setOrderDate(() -> ((CommerceOrder)commerceOrder).getOrderDate());
                this.setOrderItems(() -> (OrderItem[])TransformUtil.transformToArray((Collection)commerceOrder.getCommerceOrderItems(), commerceOrderItem -> (OrderItem)OrderDTOConverter.this._orderItemDTOConverter.toDTO(commerceOrderItem), OrderItem.class));
                this.setOrderStatus(() -> ((CommerceOrder)commerceOrder).getOrderStatus());
                this.setOrderTypeId(() -> ((CommerceOrder)commerceOrder).getCommerceOrderTypeId());
                this.setPaymentMethod(() -> ((CommerceOrder)commerceOrder).getCommercePaymentMethodKey());
                this.setPaymentStatus(() -> ((CommerceOrder)commerceOrder).getPaymentStatus());
                this.setStatus(() -> ((CommerceOrder)commerceOrder).getStatus());
                this.setTotal(() -> ((CommerceOrder)commerceOrder).getTotal());
                this.setUserId(() -> ((CommerceOrder)commerceOrder).getUserId());
            }
        };
    }
}

