/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.machine.learning.internal.dto.v1_0.converter;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetVocabularyLocalService;
import com.liferay.headless.commerce.machine.learning.dto.v1_0.Category;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.asset.kernel.model.AssetCategory"}, service={DTOConverter.class})
public class CategoryDTOConverter
implements DTOConverter<AssetCategory, Category> {
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetVocabularyLocalService _assetVocabularyLocalService;

    public String getContentType() {
        return Category.class.getSimpleName();
    }

    public AssetCategory getObject(String externalReferenceCode) throws Exception {
        return this._assetCategoryLocalService.fetchCategory(GetterUtil.getLong((String)externalReferenceCode));
    }

    public Category toDTO(DTOConverterContext dtoConverterContext, final AssetCategory assetCategory) throws Exception {
        if (assetCategory == null) {
            return null;
        }
        return new Category(){
            {
                this.setExternalReferenceCode(() -> ((AssetCategory)assetCategory).getExternalReferenceCode());
                this.setId(() -> ((AssetCategory)assetCategory).getCategoryId());
                this.setName(() -> ((AssetCategory)assetCategory).getName());
                this.setSiteId(() -> ((AssetCategory)assetCategory).getGroupId());
                this.setVocabulary(() -> {
                    AssetVocabulary assetVocabulary = CategoryDTOConverter.this._assetVocabularyLocalService.getAssetVocabulary(assetCategory.getVocabularyId());
                    return assetVocabulary.getName();
                });
            }
        };
    }
}

