/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.machine.learning.internal.dto.v1_0.converter;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.commerce.machine.learning.forecast.AssetCategoryCommerceMLForecast;
import com.liferay.commerce.machine.learning.forecast.AssetCategoryCommerceMLForecastManager;
import com.liferay.headless.commerce.machine.learning.dto.v1_0.AccountCategoryForecast;
import com.liferay.headless.commerce.machine.learning.internal.dto.v1_0.converter.CommerceMLForecastCompositeResourcePrimaryKey;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.commerce.machine.learning.forecast.model.AssetCategoryCommerceMLForecast"}, service={DTOConverter.class})
public class AccountCategoryForecastDTOConverter
implements DTOConverter<AssetCategoryCommerceMLForecast, AccountCategoryForecast> {
    @Reference
    private AssetCategoryCommerceMLForecastManager _assetCategoryCommerceMLForecastManager;
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;

    public String getContentType() {
        return AssetCategoryCommerceMLForecast.class.getSimpleName();
    }

    public AccountCategoryForecast toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        CommerceMLForecastCompositeResourcePrimaryKey compositeResourcePrimKey = (CommerceMLForecastCompositeResourcePrimaryKey)dtoConverterContext.getId();
        final AssetCategoryCommerceMLForecast assetCategoryCommerceMLForecast = this._assetCategoryCommerceMLForecastManager.getAssetCategoryCommerceMLForecast(compositeResourcePrimKey.getCompanyId(), compositeResourcePrimKey.getForecastId());
        return new AccountCategoryForecast(){
            {
                this.setAccount(() -> ((AssetCategoryCommerceMLForecast)assetCategoryCommerceMLForecast).getCommerceAccountId());
                this.setActual(() -> ((AssetCategoryCommerceMLForecast)assetCategoryCommerceMLForecast).getActual());
                this.setCategory(() -> ((AssetCategoryCommerceMLForecast)assetCategoryCommerceMLForecast).getAssetCategoryId());
                this.setCategoryTitle(() -> {
                    AssetCategory assetCategory = AccountCategoryForecastDTOConverter.this._assetCategoryLocalService.fetchAssetCategory(assetCategoryCommerceMLForecast.getAssetCategoryId());
                    if (assetCategory == null) {
                        return null;
                    }
                    return assetCategory.getTitle(LocaleUtil.toLanguageId((Locale)dtoConverterContext.getLocale()));
                });
                this.setForecast(() -> ((AssetCategoryCommerceMLForecast)assetCategoryCommerceMLForecast).getForecast());
                this.setForecastLowerBound(() -> ((AssetCategoryCommerceMLForecast)assetCategoryCommerceMLForecast).getForecastLowerBound());
                this.setForecastUpperBound(() -> ((AssetCategoryCommerceMLForecast)assetCategoryCommerceMLForecast).getForecastUpperBound());
                this.setTimestamp(() -> ((AssetCategoryCommerceMLForecast)assetCategoryCommerceMLForecast).getTimestamp());
                this.setUnit(() -> ((AssetCategoryCommerceMLForecast)assetCategoryCommerceMLForecast).getTarget());
            }
        };
    }
}

