/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.machine.learning.internal.dispatch.executor;

import com.liferay.analytics.batch.exportimport.manager.AnalyticsBatchExportImportManager;
import com.liferay.analytics.settings.configuration.AnalyticsConfiguration;
import com.liferay.analytics.settings.rest.manager.AnalyticsSettingsManager;
import com.liferay.dispatch.executor.DispatchTaskExecutorOutput;
import com.liferay.dispatch.executor.DispatchTaskStatus;
import com.liferay.dispatch.model.DispatchLog;
import com.liferay.dispatch.service.DispatchLogLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.StringUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.function.Function;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseDispatchTaskExecutor
extends com.liferay.dispatch.executor.BaseDispatchTaskExecutor {
    @Reference
    protected AnalyticsBatchExportImportManager analyticsBatchExportImportManager;
    @Reference
    protected AnalyticsSettingsManager analyticsSettingsManager;
    @Reference
    protected DispatchLogLocalService dispatchLogLocalService;
    private static final DateFormat _dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    protected String getCommerceChannelFilterString(long companyId, Function<Long, String> filterFunction) throws Exception {
        ArrayList<String> filterStrings = new ArrayList<String>();
        AnalyticsConfiguration analyticsConfiguration = this.analyticsSettingsManager.getAnalyticsConfiguration(companyId);
        for (String analyticsChannelId : analyticsConfiguration.commerceSyncEnabledAnalyticsChannelIds()) {
            for (Long commerceChannelId : this.analyticsSettingsManager.getCommerceChannelIds(analyticsChannelId, companyId)) {
                filterStrings.add(filterFunction.apply(commerceChannelId));
            }
        }
        return StringUtil.merge(filterStrings, (String)" or ");
    }

    protected Date getLatestSuccessfulDispatchLogEndDate(long dispatchTriggerId) {
        DispatchLog dispatchLog = this.dispatchLogLocalService.fetchLatestDispatchLog(dispatchTriggerId, DispatchTaskStatus.SUCCESSFUL);
        if (dispatchLog != null) {
            return dispatchLog.getEndDate();
        }
        return null;
    }

    protected void updateDispatchLog(long dispatchLogId, DispatchTaskExecutorOutput dispatchTaskExecutorOutput, String message) throws PortalException {
        StringBundler sb = new StringBundler(5);
        if (dispatchTaskExecutorOutput.getOutput() != null) {
            sb.append(dispatchTaskExecutorOutput.getOutput());
        }
        sb.append(_dateFormat.format(new Date()));
        sb.append(" ");
        sb.append(message);
        sb.append("\n");
        dispatchTaskExecutorOutput.setOutput(sb.toString());
        this.dispatchLogLocalService.updateDispatchLog(dispatchLogId, new Date(), dispatchTaskExecutorOutput.getError(), dispatchTaskExecutorOutput.getOutput(), DispatchTaskStatus.IN_PROGRESS);
    }
}

