/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.machine.learning.internal.dispatch.executor;

import com.liferay.analytics.settings.configuration.AnalyticsConfiguration;
import com.liferay.dispatch.executor.DispatchTaskExecutor;
import com.liferay.dispatch.executor.DispatchTaskExecutorOutput;
import com.liferay.dispatch.executor.DispatchTaskStatus;
import com.liferay.dispatch.model.DispatchLog;
import com.liferay.dispatch.model.DispatchTrigger;
import com.liferay.headless.commerce.machine.learning.dto.v1_0.Category;
import com.liferay.headless.commerce.machine.learning.dto.v1_0.Product;
import com.liferay.headless.commerce.machine.learning.dto.v1_0.ProductChannel;
import com.liferay.headless.commerce.machine.learning.internal.dispatch.executor.BaseDispatchTaskExecutor;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dispatch.task.executor.name=analytics-upload-product", "dispatch.task.executor.type=analytics-upload-product"}, service={DispatchTaskExecutor.class})
public class AnalyticsUploadProductDispatchTaskExecutor
extends BaseDispatchTaskExecutor {
    public static final String KEY = "analytics-upload-product";
    @Reference
    private ClassNameLocalService _classNameLocalService;
    private Supplier<Long> _commerceChannelClassNameIdSupplier;
    @Reference
    private GroupLocalService _groupLocalService;

    public void doExecute(DispatchTrigger dispatchTrigger, DispatchTaskExecutorOutput dispatchTaskExecutorOutput) throws Exception {
        DispatchLog dispatchLog = this.dispatchLogLocalService.fetchLatestDispatchLog(dispatchTrigger.getDispatchTriggerId(), DispatchTaskStatus.IN_PROGRESS);
        String filterString = this.getCommerceChannelFilterString(dispatchTrigger.getCompanyId(), commerceChannelId -> {
            Group group = this._groupLocalService.fetchGroup(dispatchTrigger.getCompanyId(), this._commerceChannelClassNameIdSupplier.get().longValue(), commerceChannelId.longValue());
            return "commerceChannelGroupIds/any(c:contains(c,'" + group.getGroupId() + "'))";
        });
        if (Objects.equals("", filterString)) {
            this.updateDispatchLog(dispatchLog.getDispatchLogId(), dispatchTaskExecutorOutput, "No Commerce Channels enabled for synchronisation");
            return;
        }
        AnalyticsConfiguration analyticsConfiguration = this.analyticsSettingsManager.getAnalyticsConfiguration(dispatchTrigger.getCompanyId());
        Date resourceLastModifiedDate = this.getLatestSuccessfulDispatchLogEndDate(dispatchTrigger.getDispatchTriggerId());
        this.analyticsBatchExportImportManager.exportToAnalyticsCloud("analytics-category", dispatchTrigger.getCompanyId(), Arrays.asList(analyticsConfiguration.syncedCategoryFieldNames()), null, message -> this.updateDispatchLog(dispatchLog.getDispatchLogId(), dispatchTaskExecutorOutput, (String)message), resourceLastModifiedDate, Category.class.getName(), dispatchTrigger.getUserId());
        this.analyticsBatchExportImportManager.exportToAnalyticsCloud("analytics-product", dispatchTrigger.getCompanyId(), Arrays.asList(analyticsConfiguration.syncedProductFieldNames()), filterString, message -> this.updateDispatchLog(dispatchLog.getDispatchLogId(), dispatchTaskExecutorOutput, (String)message), resourceLastModifiedDate, Product.class.getName(), dispatchTrigger.getUserId());
        this.analyticsBatchExportImportManager.exportToAnalyticsCloud("analytics-product-channel", dispatchTrigger.getCompanyId(), Arrays.asList(analyticsConfiguration.syncedProductChannelFieldNames()), this.getCommerceChannelFilterString(dispatchTrigger.getCompanyId(), commerceChannelId -> "entryClassPK eq '" + commerceChannelId + "'"), message -> this.updateDispatchLog(dispatchLog.getDispatchLogId(), dispatchTaskExecutorOutput, (String)message), resourceLastModifiedDate, ProductChannel.class.getName(), dispatchTrigger.getUserId());
    }

    public String getName() {
        return KEY;
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._commerceChannelClassNameIdSupplier = this._classNameLocalService.getClassNameIdSupplier("com.liferay.commerce.product.model.CommerceChannel");
    }
}

