/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.machine.learning.internal.dispatch.executor;

import com.liferay.analytics.settings.configuration.AnalyticsConfiguration;
import com.liferay.dispatch.executor.DispatchTaskExecutor;
import com.liferay.dispatch.executor.DispatchTaskExecutorOutput;
import com.liferay.dispatch.executor.DispatchTaskStatus;
import com.liferay.dispatch.model.DispatchLog;
import com.liferay.dispatch.model.DispatchTrigger;
import com.liferay.headless.commerce.machine.learning.dto.v1_0.Order;
import com.liferay.headless.commerce.machine.learning.internal.dispatch.executor.BaseDispatchTaskExecutor;
import com.liferay.portal.kernel.util.ArrayUtil;
import java.util.Arrays;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;

@Component(property={"dispatch.task.executor.name=analytics-upload-order", "dispatch.task.executor.type=analytics-upload-order"}, service={DispatchTaskExecutor.class})
public class AnalyticsUploadOrderDispatchTaskExecutor
extends BaseDispatchTaskExecutor {
    public static final String KEY = "analytics-upload-order";

    public void doExecute(DispatchTrigger dispatchTrigger, DispatchTaskExecutorOutput dispatchTaskExecutorOutput) throws Exception {
        DispatchLog dispatchLog = this.dispatchLogLocalService.fetchLatestDispatchLog(dispatchTrigger.getDispatchTriggerId(), DispatchTaskStatus.IN_PROGRESS);
        String filterString = this.getCommerceChannelFilterString(dispatchTrigger.getCompanyId(), commerceChannelId -> "commerceChannelId eq '" + commerceChannelId + "'");
        if (Objects.equals("", filterString)) {
            this.updateDispatchLog(dispatchLog.getDispatchLogId(), dispatchTaskExecutorOutput, "No commerce channels enabled for synchronisation");
            return;
        }
        AnalyticsConfiguration analyticsConfiguration = this.analyticsSettingsManager.getAnalyticsConfiguration(dispatchTrigger.getCompanyId());
        this.analyticsBatchExportImportManager.exportToAnalyticsCloud("analytics-order", dispatchTrigger.getCompanyId(), Arrays.asList(ArrayUtil.append((Object[])analyticsConfiguration.syncedOrderFieldNames(), (Object[])analyticsConfiguration.syncedOrderItemFieldNames())), filterString, message -> this.updateDispatchLog(dispatchLog.getDispatchLogId(), dispatchTaskExecutorOutput, (String)message), this.getLatestSuccessfulDispatchLogEndDate(dispatchTrigger.getDispatchTriggerId()), Order.class.getName(), dispatchTrigger.getUserId());
    }

    public String getName() {
        return KEY;
    }
}

