/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.machine.learning.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotEmpty;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(value="Sku")
@JsonFilter(value="Liferay.Vulcan")
@Schema(requiredProperties={"sku"})
@XmlRootElement(name="Sku")
public class Sku
implements Serializable {
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected BigDecimal cost;
    @JsonIgnore
    private Supplier<BigDecimal> _costSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Boolean discontinued;
    @JsonIgnore
    private Supplier<Boolean> _discontinuedSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Date displayDate;
    @JsonIgnore
    private Supplier<Date> _displayDateSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Date expirationDate;
    @JsonIgnore
    private Supplier<Date> _expirationDateSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String externalReferenceCode;
    @JsonIgnore
    private Supplier<String> _externalReferenceCodeSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String gtin;
    @JsonIgnore
    private Supplier<String> _gtinSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Long id;
    @JsonIgnore
    private Supplier<Long> _idSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String manufacturerPartNumber;
    @JsonIgnore
    private Supplier<String> _manufacturerPartNumberSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Boolean published;
    @JsonIgnore
    private Supplier<Boolean> _publishedSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Boolean purchasable;
    @JsonIgnore
    private Supplier<Boolean> _purchasableSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotEmpty
    protected String sku;
    @JsonIgnore
    private Supplier<String> _skuSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.commerce.machine.learning.dto.v1_0.Sku", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static Sku toDTO(String json) {
        return (Sku)ObjectMapperUtil.readValue(Sku.class, (String)json);
    }

    public static Sku unsafeToDTO(String json) {
        return (Sku)ObjectMapperUtil.unsafeReadValue(Sku.class, (String)json);
    }

    @DecimalMin(value="0")
    @Schema(example="101")
    @Valid
    public @DecimalMin(value="0") @Valid BigDecimal getCost() {
        if (this._costSupplier != null) {
            this.cost = this._costSupplier.get();
            this._costSupplier = null;
        }
        return this.cost;
    }

    public void setCost(BigDecimal cost) {
        this.cost = cost;
        this._costSupplier = null;
    }

    @JsonIgnore
    public void setCost(UnsafeSupplier<BigDecimal, Exception> costUnsafeSupplier) {
        this._costSupplier = () -> {
            try {
                return (BigDecimal)costUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public Boolean getDiscontinued() {
        if (this._discontinuedSupplier != null) {
            this.discontinued = this._discontinuedSupplier.get();
            this._discontinuedSupplier = null;
        }
        return this.discontinued;
    }

    public void setDiscontinued(Boolean discontinued) {
        this.discontinued = discontinued;
        this._discontinuedSupplier = null;
    }

    @JsonIgnore
    public void setDiscontinued(UnsafeSupplier<Boolean, Exception> discontinuedUnsafeSupplier) {
        this._discontinuedSupplier = () -> {
            try {
                return (Boolean)discontinuedUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="2017-07-21")
    public Date getDisplayDate() {
        if (this._displayDateSupplier != null) {
            this.displayDate = this._displayDateSupplier.get();
            this._displayDateSupplier = null;
        }
        return this.displayDate;
    }

    public void setDisplayDate(Date displayDate) {
        this.displayDate = displayDate;
        this._displayDateSupplier = null;
    }

    @JsonIgnore
    public void setDisplayDate(UnsafeSupplier<Date, Exception> displayDateUnsafeSupplier) {
        this._displayDateSupplier = () -> {
            try {
                return (Date)displayDateUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="2017-08-21")
    public Date getExpirationDate() {
        if (this._expirationDateSupplier != null) {
            this.expirationDate = this._expirationDateSupplier.get();
            this._expirationDateSupplier = null;
        }
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
        this._expirationDateSupplier = null;
    }

    @JsonIgnore
    public void setExpirationDate(UnsafeSupplier<Date, Exception> expirationDateUnsafeSupplier) {
        this._expirationDateSupplier = () -> {
            try {
                return (Date)expirationDateUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="AB-34098-789-N")
    public String getExternalReferenceCode() {
        if (this._externalReferenceCodeSupplier != null) {
            this.externalReferenceCode = this._externalReferenceCodeSupplier.get();
            this._externalReferenceCodeSupplier = null;
        }
        return this.externalReferenceCode;
    }

    public void setExternalReferenceCode(String externalReferenceCode) {
        this.externalReferenceCode = externalReferenceCode;
        this._externalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setExternalReferenceCode(UnsafeSupplier<String, Exception> externalReferenceCodeUnsafeSupplier) {
        this._externalReferenceCodeSupplier = () -> {
            try {
                return (String)externalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="12341234")
    public String getGtin() {
        if (this._gtinSupplier != null) {
            this.gtin = this._gtinSupplier.get();
            this._gtinSupplier = null;
        }
        return this.gtin;
    }

    public void setGtin(String gtin) {
        this.gtin = gtin;
        this._gtinSupplier = null;
    }

    @JsonIgnore
    public void setGtin(UnsafeSupplier<String, Exception> gtinUnsafeSupplier) {
        this._gtinSupplier = () -> {
            try {
                return (String)gtinUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @DecimalMin(value="0")
    @Schema(example="30130")
    public @DecimalMin(value="0") Long getId() {
        if (this._idSupplier != null) {
            this.id = this._idSupplier.get();
            this._idSupplier = null;
        }
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
        this._idSupplier = null;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Long, Exception> idUnsafeSupplier) {
        this._idSupplier = () -> {
            try {
                return (Long)idUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="12341234")
    public String getManufacturerPartNumber() {
        if (this._manufacturerPartNumberSupplier != null) {
            this.manufacturerPartNumber = this._manufacturerPartNumberSupplier.get();
            this._manufacturerPartNumberSupplier = null;
        }
        return this.manufacturerPartNumber;
    }

    public void setManufacturerPartNumber(String manufacturerPartNumber) {
        this.manufacturerPartNumber = manufacturerPartNumber;
        this._manufacturerPartNumberSupplier = null;
    }

    @JsonIgnore
    public void setManufacturerPartNumber(UnsafeSupplier<String, Exception> manufacturerPartNumberUnsafeSupplier) {
        this._manufacturerPartNumberSupplier = () -> {
            try {
                return (String)manufacturerPartNumberUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="true")
    public Boolean getPublished() {
        if (this._publishedSupplier != null) {
            this.published = this._publishedSupplier.get();
            this._publishedSupplier = null;
        }
        return this.published;
    }

    public void setPublished(Boolean published) {
        this.published = published;
        this._publishedSupplier = null;
    }

    @JsonIgnore
    public void setPublished(UnsafeSupplier<Boolean, Exception> publishedUnsafeSupplier) {
        this._publishedSupplier = () -> {
            try {
                return (Boolean)publishedUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="true")
    public Boolean getPurchasable() {
        if (this._purchasableSupplier != null) {
            this.purchasable = this._purchasableSupplier.get();
            this._purchasableSupplier = null;
        }
        return this.purchasable;
    }

    public void setPurchasable(Boolean purchasable) {
        this.purchasable = purchasable;
        this._purchasableSupplier = null;
    }

    @JsonIgnore
    public void setPurchasable(UnsafeSupplier<Boolean, Exception> purchasableUnsafeSupplier) {
        this._purchasableSupplier = () -> {
            try {
                return (Boolean)purchasableUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="12341234")
    public String getSku() {
        if (this._skuSupplier != null) {
            this.sku = this._skuSupplier.get();
            this._skuSupplier = null;
        }
        return this.sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
        this._skuSupplier = null;
    }

    @JsonIgnore
    public void setSku(UnsafeSupplier<String, Exception> skuUnsafeSupplier) {
        this._skuSupplier = () -> {
            try {
                return (String)skuUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Sku)) {
            return false;
        }
        Sku sku = (Sku)object;
        return Objects.equals(this.toString(), sku.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        String sku;
        Boolean purchasable;
        Boolean published;
        String manufacturerPartNumber;
        Long id;
        String gtin;
        String externalReferenceCode;
        Date expirationDate;
        Date displayDate;
        Boolean discontinued;
        StringBundler sb = new StringBundler();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        BigDecimal cost = this.getCost();
        if (cost != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"cost\": ");
            sb.append((Object)cost);
        }
        if ((discontinued = this.getDiscontinued()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"discontinued\": ");
            sb.append((Object)discontinued);
        }
        if ((displayDate = this.getDisplayDate()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"displayDate\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(displayDate));
            sb.append("\"");
        }
        if ((expirationDate = this.getExpirationDate()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"expirationDate\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(expirationDate));
            sb.append("\"");
        }
        if ((externalReferenceCode = this.getExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalReferenceCode\": ");
            sb.append("\"");
            sb.append(Sku._escape(externalReferenceCode));
            sb.append("\"");
        }
        if ((gtin = this.getGtin()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"gtin\": ");
            sb.append("\"");
            sb.append(Sku._escape(gtin));
            sb.append("\"");
        }
        if ((id = this.getId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append((Object)id);
        }
        if ((manufacturerPartNumber = this.getManufacturerPartNumber()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"manufacturerPartNumber\": ");
            sb.append("\"");
            sb.append(Sku._escape(manufacturerPartNumber));
            sb.append("\"");
        }
        if ((published = this.getPublished()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"published\": ");
            sb.append((Object)published);
        }
        if ((purchasable = this.getPurchasable()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"purchasable\": ");
            sb.append((Object)purchasable);
        }
        if ((sku = this.getSku()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"sku\": ");
            sb.append("\"");
            sb.append(Sku._escape(sku));
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(Sku._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (Sku._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(Sku._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(Sku._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(Sku._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

