/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.machine.learning.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(value="ProductSpecification")
@JsonFilter(value="Liferay.Vulcan")
@Schema(requiredProperties={"specificationKey", "value"})
@XmlRootElement(name="ProductSpecification")
public class ProductSpecification
implements Serializable {
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long id;
    @JsonIgnore
    private Supplier<Long> _idSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long optionCategoryId;
    @JsonIgnore
    private Supplier<Long> _optionCategoryIdSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotEmpty
    protected String specificationKey;
    @JsonIgnore
    private Supplier<String> _specificationKeySupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotNull
    protected Map<String, String> value;
    @JsonIgnore
    private Supplier<Map<String, String>> _valueSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.commerce.machine.learning.dto.v1_0.ProductSpecification", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static ProductSpecification toDTO(String json) {
        return (ProductSpecification)ObjectMapperUtil.readValue(ProductSpecification.class, (String)json);
    }

    public static ProductSpecification unsafeToDTO(String json) {
        return (ProductSpecification)ObjectMapperUtil.unsafeReadValue(ProductSpecification.class, (String)json);
    }

    @DecimalMin(value="0")
    @Schema(example="31130")
    public @DecimalMin(value="0") Long getId() {
        if (this._idSupplier != null) {
            this.id = this._idSupplier.get();
            this._idSupplier = null;
        }
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
        this._idSupplier = null;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Long, Exception> idUnsafeSupplier) {
        this._idSupplier = () -> {
            try {
                return (Long)idUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @DecimalMin(value="0")
    @Schema(example="30129")
    public @DecimalMin(value="0") Long getOptionCategoryId() {
        if (this._optionCategoryIdSupplier != null) {
            this.optionCategoryId = this._optionCategoryIdSupplier.get();
            this._optionCategoryIdSupplier = null;
        }
        return this.optionCategoryId;
    }

    public void setOptionCategoryId(Long optionCategoryId) {
        this.optionCategoryId = optionCategoryId;
        this._optionCategoryIdSupplier = null;
    }

    @JsonIgnore
    public void setOptionCategoryId(UnsafeSupplier<Long, Exception> optionCategoryIdUnsafeSupplier) {
        this._optionCategoryIdSupplier = () -> {
            try {
                return (Long)optionCategoryIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="specification-key")
    public String getSpecificationKey() {
        if (this._specificationKeySupplier != null) {
            this.specificationKey = this._specificationKeySupplier.get();
            this._specificationKeySupplier = null;
        }
        return this.specificationKey;
    }

    public void setSpecificationKey(String specificationKey) {
        this.specificationKey = specificationKey;
        this._specificationKeySupplier = null;
    }

    @JsonIgnore
    public void setSpecificationKey(UnsafeSupplier<String, Exception> specificationKeyUnsafeSupplier) {
        this._specificationKeySupplier = () -> {
            try {
                return (String)specificationKeyUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    @Valid
    public Map<String, String> getValue() {
        if (this._valueSupplier != null) {
            this.value = this._valueSupplier.get();
            this._valueSupplier = null;
        }
        return this.value;
    }

    public void setValue(Map<String, String> value) {
        this.value = value;
        this._valueSupplier = null;
    }

    @JsonIgnore
    public void setValue(UnsafeSupplier<Map<String, String>, Exception> valueUnsafeSupplier) {
        this._valueSupplier = () -> {
            try {
                return (Map)valueUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ProductSpecification)) {
            return false;
        }
        ProductSpecification productSpecification = (ProductSpecification)object;
        return Objects.equals(this.toString(), productSpecification.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        Map<String, String> value;
        String specificationKey;
        Long optionCategoryId;
        StringBundler sb = new StringBundler();
        sb.append("{");
        Long id = this.getId();
        if (id != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append((Object)id);
        }
        if ((optionCategoryId = this.getOptionCategoryId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"optionCategoryId\": ");
            sb.append((Object)optionCategoryId);
        }
        if ((specificationKey = this.getSpecificationKey()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"specificationKey\": ");
            sb.append("\"");
            sb.append(ProductSpecification._escape(specificationKey));
            sb.append("\"");
        }
        if ((value = this.getValue()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"value\": ");
            sb.append(ProductSpecification._toJSON(value));
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(ProductSpecification._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (ProductSpecification._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(ProductSpecification._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(ProductSpecification._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(ProductSpecification._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

