/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.machine.learning.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.headless.commerce.machine.learning.dto.v1_0.ProductOption;
import com.liferay.headless.commerce.machine.learning.dto.v1_0.ProductSpecification;
import com.liferay.headless.commerce.machine.learning.dto.v1_0.Sku;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(value="Product")
@JsonFilter(value="Liferay.Vulcan")
@Schema(requiredProperties={"catalogId", "name", "productType"})
@XmlRootElement(name="Product")
public class Product
implements Serializable {
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotNull
    protected Long catalogId;
    @JsonIgnore
    private Supplier<Long> _catalogIdSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long[] categoryIds;
    @JsonIgnore
    private Supplier<Long[]> _categoryIdsSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Date createDate;
    @JsonIgnore
    private Supplier<Date> _createDateSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Map<String, ?> customFields;
    @JsonIgnore
    private Supplier<Map<String, ?>> _customFieldsSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Map<String, String> description;
    @JsonIgnore
    private Supplier<Map<String, String>> _descriptionSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Date displayDate;
    @JsonIgnore
    private Supplier<Date> _displayDateSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Date expirationDate;
    @JsonIgnore
    private Supplier<Date> _expirationDateSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String externalReferenceCode;
    @JsonIgnore
    private Supplier<String> _externalReferenceCodeSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Long id;
    @JsonIgnore
    private Supplier<Long> _idSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Map<String, String> metaDescription;
    @JsonIgnore
    private Supplier<Map<String, String>> _metaDescriptionSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Map<String, String> metaKeyword;
    @JsonIgnore
    private Supplier<Map<String, String>> _metaKeywordSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Map<String, String> metaTitle;
    @JsonIgnore
    private Supplier<Map<String, String>> _metaTitleSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Date modifiedDate;
    @JsonIgnore
    private Supplier<Date> _modifiedDateSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotNull
    protected Map<String, String> name;
    @JsonIgnore
    private Supplier<Map<String, String>> _nameSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long[] productChannelIds;
    @JsonIgnore
    private Supplier<Long[]> _productChannelIdsSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Long productId;
    @JsonIgnore
    private Supplier<Long> _productIdSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected ProductOption[] productOptions;
    @JsonIgnore
    private Supplier<ProductOption[]> _productOptionsSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected ProductSpecification[] productSpecifications;
    @JsonIgnore
    private Supplier<ProductSpecification[]> _productSpecificationsSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotEmpty
    protected String productType;
    @JsonIgnore
    private Supplier<String> _productTypeSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Sku[] skus;
    @JsonIgnore
    private Supplier<Sku[]> _skusSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Integer status;
    @JsonIgnore
    private Supplier<Integer> _statusSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Boolean subscriptionEnabled;
    @JsonIgnore
    private Supplier<Boolean> _subscriptionEnabledSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String[] tags;
    @JsonIgnore
    private Supplier<String[]> _tagsSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Map<String, String> urls;
    @JsonIgnore
    private Supplier<Map<String, String>> _urlsSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.commerce.machine.learning.dto.v1_0.Product", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static Product toDTO(String json) {
        return (Product)ObjectMapperUtil.readValue(Product.class, (String)json);
    }

    public static Product unsafeToDTO(String json) {
        return (Product)ObjectMapperUtil.unsafeReadValue(Product.class, (String)json);
    }

    @DecimalMin(value="0")
    @Schema(example="30054")
    public @DecimalMin(value="0") Long getCatalogId() {
        if (this._catalogIdSupplier != null) {
            this.catalogId = this._catalogIdSupplier.get();
            this._catalogIdSupplier = null;
        }
        return this.catalogId;
    }

    public void setCatalogId(Long catalogId) {
        this.catalogId = catalogId;
        this._catalogIdSupplier = null;
    }

    @JsonIgnore
    public void setCatalogId(UnsafeSupplier<Long, Exception> catalogIdUnsafeSupplier) {
        this._catalogIdSupplier = () -> {
            try {
                return (Long)catalogIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public Long[] getCategoryIds() {
        if (this._categoryIdsSupplier != null) {
            this.categoryIds = this._categoryIdsSupplier.get();
            this._categoryIdsSupplier = null;
        }
        return this.categoryIds;
    }

    public void setCategoryIds(Long[] categoryIds) {
        this.categoryIds = categoryIds;
        this._categoryIdsSupplier = null;
    }

    @JsonIgnore
    public void setCategoryIds(UnsafeSupplier<Long[], Exception> categoryIdsUnsafeSupplier) {
        this._categoryIdsSupplier = () -> {
            try {
                return (Long[])categoryIdsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="2017-07-21")
    public Date getCreateDate() {
        if (this._createDateSupplier != null) {
            this.createDate = this._createDateSupplier.get();
            this._createDateSupplier = null;
        }
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
        this._createDateSupplier = null;
    }

    @JsonIgnore
    public void setCreateDate(UnsafeSupplier<Date, Exception> createDateUnsafeSupplier) {
        this._createDateSupplier = () -> {
            try {
                return (Date)createDateUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    @Valid
    public Map<String, ?> getCustomFields() {
        if (this._customFieldsSupplier != null) {
            this.customFields = this._customFieldsSupplier.get();
            this._customFieldsSupplier = null;
        }
        return this.customFields;
    }

    public void setCustomFields(Map<String, ?> customFields) {
        this.customFields = customFields;
        this._customFieldsSupplier = null;
    }

    @JsonIgnore
    public void setCustomFields(UnsafeSupplier<Map<String, ?>, Exception> customFieldsUnsafeSupplier) {
        this._customFieldsSupplier = () -> {
            try {
                return (Map)customFieldsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="{hu_HU=Product Description HU, hr_HR=Product Description HR, en_US=Professional hand stainless steel saw for wood. Made to last and saw forever. Made of best steel}")
    @Valid
    public Map<String, String> getDescription() {
        if (this._descriptionSupplier != null) {
            this.description = this._descriptionSupplier.get();
            this._descriptionSupplier = null;
        }
        return this.description;
    }

    public void setDescription(Map<String, String> description) {
        this.description = description;
        this._descriptionSupplier = null;
    }

    @JsonIgnore
    public void setDescription(UnsafeSupplier<Map<String, String>, Exception> descriptionUnsafeSupplier) {
        this._descriptionSupplier = () -> {
            try {
                return (Map)descriptionUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="2017-07-21")
    public Date getDisplayDate() {
        if (this._displayDateSupplier != null) {
            this.displayDate = this._displayDateSupplier.get();
            this._displayDateSupplier = null;
        }
        return this.displayDate;
    }

    public void setDisplayDate(Date displayDate) {
        this.displayDate = displayDate;
        this._displayDateSupplier = null;
    }

    @JsonIgnore
    public void setDisplayDate(UnsafeSupplier<Date, Exception> displayDateUnsafeSupplier) {
        this._displayDateSupplier = () -> {
            try {
                return (Date)displayDateUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="2017-08-21")
    public Date getExpirationDate() {
        if (this._expirationDateSupplier != null) {
            this.expirationDate = this._expirationDateSupplier.get();
            this._expirationDateSupplier = null;
        }
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
        this._expirationDateSupplier = null;
    }

    @JsonIgnore
    public void setExpirationDate(UnsafeSupplier<Date, Exception> expirationDateUnsafeSupplier) {
        this._expirationDateSupplier = () -> {
            try {
                return (Date)expirationDateUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="AB-34098-789-N")
    public String getExternalReferenceCode() {
        if (this._externalReferenceCodeSupplier != null) {
            this.externalReferenceCode = this._externalReferenceCodeSupplier.get();
            this._externalReferenceCodeSupplier = null;
        }
        return this.externalReferenceCode;
    }

    public void setExternalReferenceCode(String externalReferenceCode) {
        this.externalReferenceCode = externalReferenceCode;
        this._externalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setExternalReferenceCode(UnsafeSupplier<String, Exception> externalReferenceCodeUnsafeSupplier) {
        this._externalReferenceCodeSupplier = () -> {
            try {
                return (String)externalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @DecimalMin(value="0")
    @Schema(example="30130")
    public @DecimalMin(value="0") Long getId() {
        if (this._idSupplier != null) {
            this.id = this._idSupplier.get();
            this._idSupplier = null;
        }
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
        this._idSupplier = null;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Long, Exception> idUnsafeSupplier) {
        this._idSupplier = () -> {
            try {
                return (Long)idUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="{en_US=Meta description HU, hr_HR=Meta description HU, hu_HU=Meta description HU}")
    @Valid
    public Map<String, String> getMetaDescription() {
        if (this._metaDescriptionSupplier != null) {
            this.metaDescription = this._metaDescriptionSupplier.get();
            this._metaDescriptionSupplier = null;
        }
        return this.metaDescription;
    }

    public void setMetaDescription(Map<String, String> metaDescription) {
        this.metaDescription = metaDescription;
        this._metaDescriptionSupplier = null;
    }

    @JsonIgnore
    public void setMetaDescription(UnsafeSupplier<Map<String, String>, Exception> metaDescriptionUnsafeSupplier) {
        this._metaDescriptionSupplier = () -> {
            try {
                return (Map)metaDescriptionUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="{en_US=Meta keyword HU, hr_HR=Meta keyword HU, hu_HU=Meta keyword HU}")
    @Valid
    public Map<String, String> getMetaKeyword() {
        if (this._metaKeywordSupplier != null) {
            this.metaKeyword = this._metaKeywordSupplier.get();
            this._metaKeywordSupplier = null;
        }
        return this.metaKeyword;
    }

    public void setMetaKeyword(Map<String, String> metaKeyword) {
        this.metaKeyword = metaKeyword;
        this._metaKeywordSupplier = null;
    }

    @JsonIgnore
    public void setMetaKeyword(UnsafeSupplier<Map<String, String>, Exception> metaKeywordUnsafeSupplier) {
        this._metaKeywordSupplier = () -> {
            try {
                return (Map)metaKeywordUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="{en_US=Meta title HU, hr_HR=Meta title HU, hu_HU=Meta title HU}")
    @Valid
    public Map<String, String> getMetaTitle() {
        if (this._metaTitleSupplier != null) {
            this.metaTitle = this._metaTitleSupplier.get();
            this._metaTitleSupplier = null;
        }
        return this.metaTitle;
    }

    public void setMetaTitle(Map<String, String> metaTitle) {
        this.metaTitle = metaTitle;
        this._metaTitleSupplier = null;
    }

    @JsonIgnore
    public void setMetaTitle(UnsafeSupplier<Map<String, String>, Exception> metaTitleUnsafeSupplier) {
        this._metaTitleSupplier = () -> {
            try {
                return (Map)metaTitleUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="2017-08-21")
    public Date getModifiedDate() {
        if (this._modifiedDateSupplier != null) {
            this.modifiedDate = this._modifiedDateSupplier.get();
            this._modifiedDateSupplier = null;
        }
        return this.modifiedDate;
    }

    public void setModifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
        this._modifiedDateSupplier = null;
    }

    @JsonIgnore
    public void setModifiedDate(UnsafeSupplier<Date, Exception> modifiedDateUnsafeSupplier) {
        this._modifiedDateSupplier = () -> {
            try {
                return (Date)modifiedDateUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="{en_US=Hand Saw, hr_HR=Product Name HR, hu_HU=Product Name HU}")
    @Valid
    public Map<String, String> getName() {
        if (this._nameSupplier != null) {
            this.name = this._nameSupplier.get();
            this._nameSupplier = null;
        }
        return this.name;
    }

    public void setName(Map<String, String> name) {
        this.name = name;
        this._nameSupplier = null;
    }

    @JsonIgnore
    public void setName(UnsafeSupplier<Map<String, String>, Exception> nameUnsafeSupplier) {
        this._nameSupplier = () -> {
            try {
                return (Map)nameUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public Long[] getProductChannelIds() {
        if (this._productChannelIdsSupplier != null) {
            this.productChannelIds = this._productChannelIdsSupplier.get();
            this._productChannelIdsSupplier = null;
        }
        return this.productChannelIds;
    }

    public void setProductChannelIds(Long[] productChannelIds) {
        this.productChannelIds = productChannelIds;
        this._productChannelIdsSupplier = null;
    }

    @JsonIgnore
    public void setProductChannelIds(UnsafeSupplier<Long[], Exception> productChannelIdsUnsafeSupplier) {
        this._productChannelIdsSupplier = () -> {
            try {
                return (Long[])productChannelIdsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public Long getProductId() {
        if (this._productIdSupplier != null) {
            this.productId = this._productIdSupplier.get();
            this._productIdSupplier = null;
        }
        return this.productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
        this._productIdSupplier = null;
    }

    @JsonIgnore
    public void setProductId(UnsafeSupplier<Long, Exception> productIdUnsafeSupplier) {
        this._productIdSupplier = () -> {
            try {
                return (Long)productIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    @Valid
    public ProductOption[] getProductOptions() {
        if (this._productOptionsSupplier != null) {
            this.productOptions = this._productOptionsSupplier.get();
            this._productOptionsSupplier = null;
        }
        return this.productOptions;
    }

    public void setProductOptions(ProductOption[] productOptions) {
        this.productOptions = productOptions;
        this._productOptionsSupplier = null;
    }

    @JsonIgnore
    public void setProductOptions(UnsafeSupplier<ProductOption[], Exception> productOptionsUnsafeSupplier) {
        this._productOptionsSupplier = () -> {
            try {
                return (ProductOption[])productOptionsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    @Valid
    public ProductSpecification[] getProductSpecifications() {
        if (this._productSpecificationsSupplier != null) {
            this.productSpecifications = this._productSpecificationsSupplier.get();
            this._productSpecificationsSupplier = null;
        }
        return this.productSpecifications;
    }

    public void setProductSpecifications(ProductSpecification[] productSpecifications) {
        this.productSpecifications = productSpecifications;
        this._productSpecificationsSupplier = null;
    }

    @JsonIgnore
    public void setProductSpecifications(UnsafeSupplier<ProductSpecification[], Exception> productSpecificationsUnsafeSupplier) {
        this._productSpecificationsSupplier = () -> {
            try {
                return (ProductSpecification[])productSpecificationsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="simple")
    public String getProductType() {
        if (this._productTypeSupplier != null) {
            this.productType = this._productTypeSupplier.get();
            this._productTypeSupplier = null;
        }
        return this.productType;
    }

    public void setProductType(String productType) {
        this.productType = productType;
        this._productTypeSupplier = null;
    }

    @JsonIgnore
    public void setProductType(UnsafeSupplier<String, Exception> productTypeUnsafeSupplier) {
        this._productTypeSupplier = () -> {
            try {
                return (String)productTypeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    @Valid
    public Sku[] getSkus() {
        if (this._skusSupplier != null) {
            this.skus = this._skusSupplier.get();
            this._skusSupplier = null;
        }
        return this.skus;
    }

    public void setSkus(Sku[] skus) {
        this.skus = skus;
        this._skusSupplier = null;
    }

    @JsonIgnore
    public void setSkus(UnsafeSupplier<Sku[], Exception> skusUnsafeSupplier) {
        this._skusSupplier = () -> {
            try {
                return (Sku[])skusUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public Integer getStatus() {
        if (this._statusSupplier != null) {
            this.status = this._statusSupplier.get();
            this._statusSupplier = null;
        }
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
        this._statusSupplier = null;
    }

    @JsonIgnore
    public void setStatus(UnsafeSupplier<Integer, Exception> statusUnsafeSupplier) {
        this._statusSupplier = () -> {
            try {
                return (Integer)statusUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public Boolean getSubscriptionEnabled() {
        if (this._subscriptionEnabledSupplier != null) {
            this.subscriptionEnabled = this._subscriptionEnabledSupplier.get();
            this._subscriptionEnabledSupplier = null;
        }
        return this.subscriptionEnabled;
    }

    public void setSubscriptionEnabled(Boolean subscriptionEnabled) {
        this.subscriptionEnabled = subscriptionEnabled;
        this._subscriptionEnabledSupplier = null;
    }

    @JsonIgnore
    public void setSubscriptionEnabled(UnsafeSupplier<Boolean, Exception> subscriptionEnabledUnsafeSupplier) {
        this._subscriptionEnabledSupplier = () -> {
            try {
                return (Boolean)subscriptionEnabledUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="[tag1, tag2, tag3]")
    public String[] getTags() {
        if (this._tagsSupplier != null) {
            this.tags = this._tagsSupplier.get();
            this._tagsSupplier = null;
        }
        return this.tags;
    }

    public void setTags(String[] tags) {
        this.tags = tags;
        this._tagsSupplier = null;
    }

    @JsonIgnore
    public void setTags(UnsafeSupplier<String[], Exception> tagsUnsafeSupplier) {
        this._tagsSupplier = () -> {
            try {
                return (String[])tagsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="{en_US=product-url-us, hr_HR=product-url-hr, hu_HU=product-url-hu}")
    @Valid
    public Map<String, String> getUrls() {
        if (this._urlsSupplier != null) {
            this.urls = this._urlsSupplier.get();
            this._urlsSupplier = null;
        }
        return this.urls;
    }

    public void setUrls(Map<String, String> urls) {
        this.urls = urls;
        this._urlsSupplier = null;
    }

    @JsonIgnore
    public void setUrls(UnsafeSupplier<Map<String, String>, Exception> urlsUnsafeSupplier) {
        this._urlsSupplier = () -> {
            try {
                return (Map)urlsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Product)) {
            return false;
        }
        Product product = (Product)object;
        return Objects.equals(this.toString(), product.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        Map<String, String> urls;
        String[] tags;
        Boolean subscriptionEnabled;
        Integer status;
        Sku[] skus;
        String productType;
        ProductSpecification[] productSpecifications;
        ProductOption[] productOptions;
        Long productId;
        Long[] productChannelIds;
        Map<String, String> name;
        Date modifiedDate;
        Map<String, String> metaTitle;
        Map<String, String> metaKeyword;
        Map<String, String> metaDescription;
        Long id;
        String externalReferenceCode;
        Date expirationDate;
        Date displayDate;
        Map<String, String> description;
        Map<String, ?> customFields;
        Date createDate;
        Long[] categoryIds;
        StringBundler sb = new StringBundler();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        Long catalogId = this.getCatalogId();
        if (catalogId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"catalogId\": ");
            sb.append((Object)catalogId);
        }
        if ((categoryIds = this.getCategoryIds()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"categoryIds\": ");
            sb.append("[");
            for (int i = 0; i < categoryIds.length; ++i) {
                sb.append((Object)categoryIds[i]);
                if (i + 1 >= categoryIds.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((createDate = this.getCreateDate()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"createDate\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(createDate));
            sb.append("\"");
        }
        if ((customFields = this.getCustomFields()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"customFields\": ");
            sb.append(Product._toJSON(customFields));
        }
        if ((description = this.getDescription()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"description\": ");
            sb.append(Product._toJSON(description));
        }
        if ((displayDate = this.getDisplayDate()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"displayDate\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(displayDate));
            sb.append("\"");
        }
        if ((expirationDate = this.getExpirationDate()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"expirationDate\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(expirationDate));
            sb.append("\"");
        }
        if ((externalReferenceCode = this.getExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalReferenceCode\": ");
            sb.append("\"");
            sb.append(Product._escape(externalReferenceCode));
            sb.append("\"");
        }
        if ((id = this.getId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append((Object)id);
        }
        if ((metaDescription = this.getMetaDescription()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"metaDescription\": ");
            sb.append(Product._toJSON(metaDescription));
        }
        if ((metaKeyword = this.getMetaKeyword()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"metaKeyword\": ");
            sb.append(Product._toJSON(metaKeyword));
        }
        if ((metaTitle = this.getMetaTitle()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"metaTitle\": ");
            sb.append(Product._toJSON(metaTitle));
        }
        if ((modifiedDate = this.getModifiedDate()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"modifiedDate\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(modifiedDate));
            sb.append("\"");
        }
        if ((name = this.getName()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name\": ");
            sb.append(Product._toJSON(name));
        }
        if ((productChannelIds = this.getProductChannelIds()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"productChannelIds\": ");
            sb.append("[");
            for (int i = 0; i < productChannelIds.length; ++i) {
                sb.append((Object)productChannelIds[i]);
                if (i + 1 >= productChannelIds.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((productId = this.getProductId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"productId\": ");
            sb.append((Object)productId);
        }
        if ((productOptions = this.getProductOptions()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"productOptions\": ");
            sb.append("[");
            for (int i = 0; i < productOptions.length; ++i) {
                sb.append(String.valueOf(productOptions[i]));
                if (i + 1 >= productOptions.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((productSpecifications = this.getProductSpecifications()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"productSpecifications\": ");
            sb.append("[");
            for (int i = 0; i < productSpecifications.length; ++i) {
                sb.append(String.valueOf(productSpecifications[i]));
                if (i + 1 >= productSpecifications.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((productType = this.getProductType()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"productType\": ");
            sb.append("\"");
            sb.append(Product._escape(productType));
            sb.append("\"");
        }
        if ((skus = this.getSkus()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"skus\": ");
            sb.append("[");
            for (int i = 0; i < skus.length; ++i) {
                sb.append(String.valueOf(skus[i]));
                if (i + 1 >= skus.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((status = this.getStatus()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"status\": ");
            sb.append((Object)status);
        }
        if ((subscriptionEnabled = this.getSubscriptionEnabled()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"subscriptionEnabled\": ");
            sb.append((Object)subscriptionEnabled);
        }
        if ((tags = this.getTags()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"tags\": ");
            sb.append("[");
            for (int i = 0; i < tags.length; ++i) {
                sb.append("\"");
                sb.append(Product._escape(tags[i]));
                sb.append("\"");
                if (i + 1 >= tags.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((urls = this.getUrls()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"urls\": ");
            sb.append(Product._toJSON(urls));
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(Product._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (Product._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(Product._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(Product._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(Product._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

