/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.machine.learning.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.headless.commerce.machine.learning.dto.v1_0.OrderItem;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(value="Order")
@JsonFilter(value="Liferay.Vulcan")
@Schema(requiredProperties={"channelId", "currencyCode"})
@XmlRootElement(name="Order")
public class Order
implements Serializable {
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long accountId;
    @JsonIgnore
    private Supplier<Long> _accountIdSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotNull
    protected Long channelId;
    @JsonIgnore
    private Supplier<Long> _channelIdSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Date createDate;
    @JsonIgnore
    private Supplier<Date> _createDateSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotEmpty
    protected String currencyCode;
    @JsonIgnore
    private Supplier<String> _currencyCodeSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Map<String, ?> customFields;
    @JsonIgnore
    private Supplier<Map<String, ?>> _customFieldsSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String externalReferenceCode;
    @JsonIgnore
    private Supplier<String> _externalReferenceCodeSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long id;
    @JsonIgnore
    private Supplier<Long> _idSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Date modifiedDate;
    @JsonIgnore
    private Supplier<Date> _modifiedDateSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Date orderDate;
    @JsonIgnore
    private Supplier<Date> _orderDateSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected OrderItem[] orderItems;
    @JsonIgnore
    private Supplier<OrderItem[]> _orderItemsSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Integer orderStatus;
    @JsonIgnore
    private Supplier<Integer> _orderStatusSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String orderTypeExternalReferenceCode;
    @JsonIgnore
    private Supplier<String> _orderTypeExternalReferenceCodeSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long orderTypeId;
    @JsonIgnore
    private Supplier<Long> _orderTypeIdSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String paymentMethod;
    @JsonIgnore
    private Supplier<String> _paymentMethodSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Integer paymentStatus;
    @JsonIgnore
    private Supplier<Integer> _paymentStatusSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Integer status;
    @JsonIgnore
    private Supplier<Integer> _statusSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected BigDecimal total;
    @JsonIgnore
    private Supplier<BigDecimal> _totalSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Long userId;
    @JsonIgnore
    private Supplier<Long> _userIdSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.commerce.machine.learning.dto.v1_0.Order", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static Order toDTO(String json) {
        return (Order)ObjectMapperUtil.readValue(Order.class, (String)json);
    }

    public static Order unsafeToDTO(String json) {
        return (Order)ObjectMapperUtil.unsafeReadValue(Order.class, (String)json);
    }

    @DecimalMin(value="0")
    @Schema(example="30130")
    public @DecimalMin(value="0") Long getAccountId() {
        if (this._accountIdSupplier != null) {
            this.accountId = this._accountIdSupplier.get();
            this._accountIdSupplier = null;
        }
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
        this._accountIdSupplier = null;
    }

    @JsonIgnore
    public void setAccountId(UnsafeSupplier<Long, Exception> accountIdUnsafeSupplier) {
        this._accountIdSupplier = () -> {
            try {
                return (Long)accountIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @DecimalMin(value="0")
    @Schema(example="30130")
    public @DecimalMin(value="0") Long getChannelId() {
        if (this._channelIdSupplier != null) {
            this.channelId = this._channelIdSupplier.get();
            this._channelIdSupplier = null;
        }
        return this.channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
        this._channelIdSupplier = null;
    }

    @JsonIgnore
    public void setChannelId(UnsafeSupplier<Long, Exception> channelIdUnsafeSupplier) {
        this._channelIdSupplier = () -> {
            try {
                return (Long)channelIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="2017-07-21")
    public Date getCreateDate() {
        if (this._createDateSupplier != null) {
            this.createDate = this._createDateSupplier.get();
            this._createDateSupplier = null;
        }
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
        this._createDateSupplier = null;
    }

    @JsonIgnore
    public void setCreateDate(UnsafeSupplier<Date, Exception> createDateUnsafeSupplier) {
        this._createDateSupplier = () -> {
            try {
                return (Date)createDateUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="USD")
    public String getCurrencyCode() {
        if (this._currencyCodeSupplier != null) {
            this.currencyCode = this._currencyCodeSupplier.get();
            this._currencyCodeSupplier = null;
        }
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        this._currencyCodeSupplier = null;
    }

    @JsonIgnore
    public void setCurrencyCode(UnsafeSupplier<String, Exception> currencyCodeUnsafeSupplier) {
        this._currencyCodeSupplier = () -> {
            try {
                return (String)currencyCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    @Valid
    public Map<String, ?> getCustomFields() {
        if (this._customFieldsSupplier != null) {
            this.customFields = this._customFieldsSupplier.get();
            this._customFieldsSupplier = null;
        }
        return this.customFields;
    }

    public void setCustomFields(Map<String, ?> customFields) {
        this.customFields = customFields;
        this._customFieldsSupplier = null;
    }

    @JsonIgnore
    public void setCustomFields(UnsafeSupplier<Map<String, ?>, Exception> customFieldsUnsafeSupplier) {
        this._customFieldsSupplier = () -> {
            try {
                return (Map)customFieldsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="AB-34098-789-N")
    public String getExternalReferenceCode() {
        if (this._externalReferenceCodeSupplier != null) {
            this.externalReferenceCode = this._externalReferenceCodeSupplier.get();
            this._externalReferenceCodeSupplier = null;
        }
        return this.externalReferenceCode;
    }

    public void setExternalReferenceCode(String externalReferenceCode) {
        this.externalReferenceCode = externalReferenceCode;
        this._externalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setExternalReferenceCode(UnsafeSupplier<String, Exception> externalReferenceCodeUnsafeSupplier) {
        this._externalReferenceCodeSupplier = () -> {
            try {
                return (String)externalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @DecimalMin(value="0")
    @Schema(example="30130")
    public @DecimalMin(value="0") Long getId() {
        if (this._idSupplier != null) {
            this.id = this._idSupplier.get();
            this._idSupplier = null;
        }
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
        this._idSupplier = null;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Long, Exception> idUnsafeSupplier) {
        this._idSupplier = () -> {
            try {
                return (Long)idUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="2017-08-21")
    public Date getModifiedDate() {
        if (this._modifiedDateSupplier != null) {
            this.modifiedDate = this._modifiedDateSupplier.get();
            this._modifiedDateSupplier = null;
        }
        return this.modifiedDate;
    }

    public void setModifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
        this._modifiedDateSupplier = null;
    }

    @JsonIgnore
    public void setModifiedDate(UnsafeSupplier<Date, Exception> modifiedDateUnsafeSupplier) {
        this._modifiedDateSupplier = () -> {
            try {
                return (Date)modifiedDateUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="2017-07-21")
    public Date getOrderDate() {
        if (this._orderDateSupplier != null) {
            this.orderDate = this._orderDateSupplier.get();
            this._orderDateSupplier = null;
        }
        return this.orderDate;
    }

    public void setOrderDate(Date orderDate) {
        this.orderDate = orderDate;
        this._orderDateSupplier = null;
    }

    @JsonIgnore
    public void setOrderDate(UnsafeSupplier<Date, Exception> orderDateUnsafeSupplier) {
        this._orderDateSupplier = () -> {
            try {
                return (Date)orderDateUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    @Valid
    public OrderItem[] getOrderItems() {
        if (this._orderItemsSupplier != null) {
            this.orderItems = this._orderItemsSupplier.get();
            this._orderItemsSupplier = null;
        }
        return this.orderItems;
    }

    public void setOrderItems(OrderItem[] orderItems) {
        this.orderItems = orderItems;
        this._orderItemsSupplier = null;
    }

    @JsonIgnore
    public void setOrderItems(UnsafeSupplier<OrderItem[], Exception> orderItemsUnsafeSupplier) {
        this._orderItemsSupplier = () -> {
            try {
                return (OrderItem[])orderItemsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @DecimalMin(value="0")
    @Schema(example="0")
    public @DecimalMin(value="0") Integer getOrderStatus() {
        if (this._orderStatusSupplier != null) {
            this.orderStatus = this._orderStatusSupplier.get();
            this._orderStatusSupplier = null;
        }
        return this.orderStatus;
    }

    public void setOrderStatus(Integer orderStatus) {
        this.orderStatus = orderStatus;
        this._orderStatusSupplier = null;
    }

    @JsonIgnore
    public void setOrderStatus(UnsafeSupplier<Integer, Exception> orderStatusUnsafeSupplier) {
        this._orderStatusSupplier = () -> {
            try {
                return (Integer)orderStatusUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="AB-34098-789-N")
    public String getOrderTypeExternalReferenceCode() {
        if (this._orderTypeExternalReferenceCodeSupplier != null) {
            this.orderTypeExternalReferenceCode = this._orderTypeExternalReferenceCodeSupplier.get();
            this._orderTypeExternalReferenceCodeSupplier = null;
        }
        return this.orderTypeExternalReferenceCode;
    }

    public void setOrderTypeExternalReferenceCode(String orderTypeExternalReferenceCode) {
        this.orderTypeExternalReferenceCode = orderTypeExternalReferenceCode;
        this._orderTypeExternalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setOrderTypeExternalReferenceCode(UnsafeSupplier<String, Exception> orderTypeExternalReferenceCodeUnsafeSupplier) {
        this._orderTypeExternalReferenceCodeSupplier = () -> {
            try {
                return (String)orderTypeExternalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @DecimalMin(value="0")
    @Schema(example="30130")
    public @DecimalMin(value="0") Long getOrderTypeId() {
        if (this._orderTypeIdSupplier != null) {
            this.orderTypeId = this._orderTypeIdSupplier.get();
            this._orderTypeIdSupplier = null;
        }
        return this.orderTypeId;
    }

    public void setOrderTypeId(Long orderTypeId) {
        this.orderTypeId = orderTypeId;
        this._orderTypeIdSupplier = null;
    }

    @JsonIgnore
    public void setOrderTypeId(UnsafeSupplier<Long, Exception> orderTypeIdUnsafeSupplier) {
        this._orderTypeIdSupplier = () -> {
            try {
                return (Long)orderTypeIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(example="paypal")
    public String getPaymentMethod() {
        if (this._paymentMethodSupplier != null) {
            this.paymentMethod = this._paymentMethodSupplier.get();
            this._paymentMethodSupplier = null;
        }
        return this.paymentMethod;
    }

    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
        this._paymentMethodSupplier = null;
    }

    @JsonIgnore
    public void setPaymentMethod(UnsafeSupplier<String, Exception> paymentMethodUnsafeSupplier) {
        this._paymentMethodSupplier = () -> {
            try {
                return (String)paymentMethodUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @DecimalMin(value="0")
    @Schema(example="0")
    public @DecimalMin(value="0") Integer getPaymentStatus() {
        if (this._paymentStatusSupplier != null) {
            this.paymentStatus = this._paymentStatusSupplier.get();
            this._paymentStatusSupplier = null;
        }
        return this.paymentStatus;
    }

    public void setPaymentStatus(Integer paymentStatus) {
        this.paymentStatus = paymentStatus;
        this._paymentStatusSupplier = null;
    }

    @JsonIgnore
    public void setPaymentStatus(UnsafeSupplier<Integer, Exception> paymentStatusUnsafeSupplier) {
        this._paymentStatusSupplier = () -> {
            try {
                return (Integer)paymentStatusUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public Integer getStatus() {
        if (this._statusSupplier != null) {
            this.status = this._statusSupplier.get();
            this._statusSupplier = null;
        }
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
        this._statusSupplier = null;
    }

    @JsonIgnore
    public void setStatus(UnsafeSupplier<Integer, Exception> statusUnsafeSupplier) {
        this._statusSupplier = () -> {
            try {
                return (Integer)statusUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @DecimalMin(value="0")
    @Schema(example="113")
    @Valid
    public @DecimalMin(value="0") @Valid BigDecimal getTotal() {
        if (this._totalSupplier != null) {
            this.total = this._totalSupplier.get();
            this._totalSupplier = null;
        }
        return this.total;
    }

    public void setTotal(BigDecimal total) {
        this.total = total;
        this._totalSupplier = null;
    }

    @JsonIgnore
    public void setTotal(UnsafeSupplier<BigDecimal, Exception> totalUnsafeSupplier) {
        this._totalSupplier = () -> {
            try {
                return (BigDecimal)totalUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public Long getUserId() {
        if (this._userIdSupplier != null) {
            this.userId = this._userIdSupplier.get();
            this._userIdSupplier = null;
        }
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
        this._userIdSupplier = null;
    }

    @JsonIgnore
    public void setUserId(UnsafeSupplier<Long, Exception> userIdUnsafeSupplier) {
        this._userIdSupplier = () -> {
            try {
                return (Long)userIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Order)) {
            return false;
        }
        Order order = (Order)object;
        return Objects.equals(this.toString(), order.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        Long userId;
        BigDecimal total;
        Integer status;
        Integer paymentStatus;
        String paymentMethod;
        Long orderTypeId;
        String orderTypeExternalReferenceCode;
        Integer orderStatus;
        OrderItem[] orderItems;
        Date orderDate;
        Date modifiedDate;
        Long id;
        String externalReferenceCode;
        Map<String, ?> customFields;
        String currencyCode;
        Date createDate;
        Long channelId;
        StringBundler sb = new StringBundler();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        Long accountId = this.getAccountId();
        if (accountId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"accountId\": ");
            sb.append((Object)accountId);
        }
        if ((channelId = this.getChannelId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"channelId\": ");
            sb.append((Object)channelId);
        }
        if ((createDate = this.getCreateDate()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"createDate\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(createDate));
            sb.append("\"");
        }
        if ((currencyCode = this.getCurrencyCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"currencyCode\": ");
            sb.append("\"");
            sb.append(Order._escape(currencyCode));
            sb.append("\"");
        }
        if ((customFields = this.getCustomFields()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"customFields\": ");
            sb.append(Order._toJSON(customFields));
        }
        if ((externalReferenceCode = this.getExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalReferenceCode\": ");
            sb.append("\"");
            sb.append(Order._escape(externalReferenceCode));
            sb.append("\"");
        }
        if ((id = this.getId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append((Object)id);
        }
        if ((modifiedDate = this.getModifiedDate()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"modifiedDate\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(modifiedDate));
            sb.append("\"");
        }
        if ((orderDate = this.getOrderDate()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"orderDate\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(orderDate));
            sb.append("\"");
        }
        if ((orderItems = this.getOrderItems()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"orderItems\": ");
            sb.append("[");
            for (int i = 0; i < orderItems.length; ++i) {
                sb.append(String.valueOf(orderItems[i]));
                if (i + 1 >= orderItems.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((orderStatus = this.getOrderStatus()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"orderStatus\": ");
            sb.append((Object)orderStatus);
        }
        if ((orderTypeExternalReferenceCode = this.getOrderTypeExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"orderTypeExternalReferenceCode\": ");
            sb.append("\"");
            sb.append(Order._escape(orderTypeExternalReferenceCode));
            sb.append("\"");
        }
        if ((orderTypeId = this.getOrderTypeId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"orderTypeId\": ");
            sb.append((Object)orderTypeId);
        }
        if ((paymentMethod = this.getPaymentMethod()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"paymentMethod\": ");
            sb.append("\"");
            sb.append(Order._escape(paymentMethod));
            sb.append("\"");
        }
        if ((paymentStatus = this.getPaymentStatus()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"paymentStatus\": ");
            sb.append((Object)paymentStatus);
        }
        if ((status = this.getStatus()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"status\": ");
            sb.append((Object)status);
        }
        if ((total = this.getTotal()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"total\": ");
            sb.append((Object)total);
        }
        if ((userId = this.getUserId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"userId\": ");
            sb.append((Object)userId);
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(Order._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (Order._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(Order._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(Order._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(Order._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

