/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.delivery.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.exception.NoSuchChannelException;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.wish.list.model.CommerceWishList;
import com.liferay.commerce.wish.list.service.CommerceWishListService;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.WishList;
import com.liferay.headless.commerce.delivery.catalog.internal.dto.v1_0.converter.WishListDTOConverter;
import com.liferay.headless.commerce.delivery.catalog.internal.resource.v1_0.BaseWishListResourceImpl;
import com.liferay.headless.commerce.delivery.catalog.resource.v1_0.WishListResource;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/wish-list.properties"}, scope=ServiceScope.PROTOTYPE, service={WishListResource.class})
public class WishListResourceImpl
extends BaseWishListResourceImpl {
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceWishListService _commerceWishListService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ServiceContextHelper _serviceContextHelper;
    @Reference
    private WishListDTOConverter _wishListDTOConverter;

    @Override
    public void deleteWishList(Long wishListId) throws Exception {
        this._commerceWishListService.deleteCommerceWishList(wishListId.longValue());
    }

    @Override
    public Page<WishList> getChannelWishListsPage(Long channelId, Long accountId, Pagination pagination) throws Exception {
        CommerceChannel commerceChannel = this._commerceChannelLocalService.fetchCommerceChannel(channelId.longValue());
        if (commerceChannel == null) {
            throw new NoSuchChannelException();
        }
        return Page.of(this.transform(this._commerceWishListService.getCommerceWishLists(commerceChannel.getSiteGroupId(), this.contextUser.getUserId(), pagination.getStartPosition(), pagination.getEndPosition(), null), commerceWishList -> this._toWishList((CommerceWishList)commerceWishList)), (Pagination)pagination, (long)this._commerceWishListService.getCommerceWishListsCount(commerceChannel.getSiteGroupId(), this.contextUser.getUserId()));
    }

    @Override
    public WishList getWishList(Long wishListId) throws Exception {
        return this._toWishList(this._commerceWishListService.getCommerceWishList(wishListId.longValue()));
    }

    @Override
    public WishList patchChannelWishList(Long wishListId, WishList wishList) throws Exception {
        CommerceWishList commerceWishList = this._commerceWishListService.getCommerceWishList(wishListId.longValue());
        return this._toWishList(this._commerceWishListService.updateCommerceWishList(wishListId.longValue(), GetterUtil.getString((String)wishList.getName(), (String)commerceWishList.getName()), GetterUtil.getBoolean((Object)wishList.getDefaultWishList(), (boolean)commerceWishList.isDefaultWishList())));
    }

    @Override
    public WishList postChannelWishList(Long channelId, Long accountId, WishList wishList) throws Exception {
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannel(channelId.longValue());
        return this._toWishList(this._commerceWishListService.addCommerceWishList(GetterUtil.getString((String)wishList.getName()), GetterUtil.getBoolean((Object)wishList.getDefaultWishList()), this._serviceContextHelper.getServiceContext(commerceChannel.getSiteGroupId())));
    }

    private WishList _toWishList(CommerceWishList commerceWishList) throws Exception {
        return this._wishListDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this._dtoConverterRegistry, (Object)commerceWishList.getCommerceWishListId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }
}

