/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.delivery.catalog.internal.resource.v1_0;

import com.liferay.commerce.account.exception.NoSuchAccountException;
import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.service.CommerceAccountLocalService;
import com.liferay.commerce.account.util.CommerceAccountHelper;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.context.CommerceContextFactory;
import com.liferay.commerce.product.exception.NoSuchChannelException;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.wish.list.model.CommerceWishList;
import com.liferay.commerce.wish.list.model.CommerceWishListItem;
import com.liferay.commerce.wish.list.service.CommerceWishListItemService;
import com.liferay.commerce.wish.list.service.CommerceWishListService;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.WishList;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.WishListItem;
import com.liferay.headless.commerce.delivery.catalog.internal.dto.v1_0.converter.WishListItemDTOConverter;
import com.liferay.headless.commerce.delivery.catalog.internal.resource.v1_0.BaseWishListItemResourceImpl;
import com.liferay.headless.commerce.delivery.catalog.resource.v1_0.WishListItemResource;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/wish-list-item.properties"}, scope=ServiceScope.PROTOTYPE, service={NestedFieldSupport.class, WishListItemResource.class})
public class WishListItemResourceImpl
extends BaseWishListItemResourceImpl
implements NestedFieldSupport {
    @Reference
    private CommerceAccountHelper _commerceAccountHelper;
    @Reference
    private CommerceAccountLocalService _commerceAccountLocalService;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceContextFactory _commerceContextFactory;
    @Reference
    private CommerceWishListItemService _commerceWishListItemService;
    @Reference
    private CommerceWishListService _commerceWishListService;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ServiceContextHelper _serviceContextHelper;
    @Reference
    private WishListItemDTOConverter _wishListItemDTOConverter;

    @Override
    public void deleteWishListItem(Long wishListItemId) throws Exception {
        this._commerceWishListItemService.deleteCommerceWishListItem(wishListItemId.longValue());
    }

    @Override
    public WishListItem getWishListItem(Long wishListItemId, Long accountId) throws Exception {
        CommerceWishListItem commerceWishListItem = this._commerceWishListItemService.getCommerceWishListItem(wishListItemId.longValue());
        CommerceChannel commerceChannel = this._commerceChannelLocalService.fetchCommerceChannelBySiteGroupId(commerceWishListItem.getGroupId());
        if (commerceChannel == null) {
            throw new NoSuchChannelException();
        }
        CommerceContext commerceContext = this._commerceContextFactory.create(commerceChannel.getCompanyId(), commerceChannel.getGroupId(), commerceChannel.getUserId(), 0L, this._getCommerceAccountId(accountId, commerceChannel).longValue());
        return this._toWishListItem(commerceWishListItem, commerceContext);
    }

    @Override
    @NestedField(parentClass=WishList.class, value="wishListItems")
    public Page<WishListItem> getWishListItemsPage(@NestedFieldId(value="id") Long wishListId, Long accountId, Pagination pagination) throws Exception {
        CommerceWishList commerceWishList = this._commerceWishListService.getCommerceWishList(wishListId.longValue());
        CommerceChannel commerceChannel = this._commerceChannelLocalService.fetchCommerceChannelBySiteGroupId(commerceWishList.getGroupId());
        if (commerceChannel == null) {
            throw new NoSuchChannelException();
        }
        CommerceContext commerceContext = this._commerceContextFactory.create(commerceChannel.getCompanyId(), commerceChannel.getGroupId(), commerceChannel.getUserId(), 0L, this._getCommerceAccountId(accountId, commerceChannel).longValue());
        return Page.of(this.transform(this._commerceWishListItemService.getCommerceWishListItems(wishListId.longValue(), pagination.getStartPosition(), pagination.getEndPosition(), null), commerceWishListItem -> this._toWishListItem((CommerceWishListItem)commerceWishListItem, commerceContext)), (Pagination)pagination, (long)this._commerceWishListItemService.getCommerceWishListItemsCount(wishListId.longValue()));
    }

    @Override
    public WishListItem postChannelWishListItem(Long wishListId, Long accountId, WishListItem wishListItem) throws Exception {
        CommerceWishList commerceWishList;
        CommerceChannel commerceChannel;
        CPInstance cpInstance = this._cpInstanceLocalService.getCPInstance(GetterUtil.getLong((Object)wishListItem.getSkuId()));
        String cpInstanceUuid = "";
        if (cpInstance != null) {
            cpInstanceUuid = cpInstance.getCPInstanceUuid();
        }
        if ((commerceChannel = this._commerceChannelLocalService.fetchCommerceChannelBySiteGroupId((commerceWishList = this._commerceWishListService.getCommerceWishList(wishListId.longValue())).getGroupId())) == null) {
            throw new NoSuchChannelException();
        }
        CommerceWishListItem commerceWishListItem = this._commerceWishListItemService.addCommerceWishListItem(this._getCommerceAccountId(accountId, commerceChannel).longValue(), wishListId.longValue(), wishListItem.getProductId().longValue(), cpInstanceUuid, wishListItem.toString(), this._serviceContextHelper.getServiceContext(commerceChannel.getSiteGroupId()));
        return this._toWishListItem(commerceWishListItem, this._commerceContextFactory.create(commerceChannel.getCompanyId(), commerceChannel.getGroupId(), commerceChannel.getUserId(), 0L, this._getCommerceAccountId(accountId, commerceChannel).longValue()));
    }

    private Long _getCommerceAccountId(Long accountId, CommerceChannel commerceChannel) throws Exception {
        int countUserCommerceAccounts = this._commerceAccountHelper.countUserCommerceAccounts(this.contextUser.getUserId(), commerceChannel.getGroupId());
        if (countUserCommerceAccounts > 1) {
            if (accountId == null) {
                throw new NoSuchAccountException();
            }
        } else {
            long[] commerceAccountIds = this._commerceAccountHelper.getUserCommerceAccountIds(this.contextUser.getUserId(), commerceChannel.getGroupId());
            if (commerceAccountIds.length == 0) {
                CommerceAccount commerceAccount = this._commerceAccountLocalService.getGuestCommerceAccount(this.contextUser.getCompanyId());
                commerceAccountIds = new long[]{commerceAccount.getCommerceAccountId()};
            }
            return commerceAccountIds[0];
        }
        return accountId;
    }

    private WishListItem _toWishListItem(CommerceWishListItem commerceWishListItem, CommerceContext commerceContext) throws Exception {
        return this._wishListItemDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this._dtoConverterRegistry, (Object)commerceWishListItem.getCommerceWishListItemId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser), commerceContext);
    }
}

