/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.delivery.catalog.internal.resource.v1_0;

import com.liferay.commerce.account.exception.NoSuchAccountException;
import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.service.CommerceAccountLocalService;
import com.liferay.commerce.account.util.CommerceAccountHelper;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.context.CommerceContextFactory;
import com.liferay.commerce.product.exception.NoSuchCProductException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.permission.CommerceProductViewPermission;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.delivery.catalog.dto.v1_0.Sku;
import com.liferay.headless.commerce.delivery.catalog.internal.dto.v1_0.converter.SkuDTOConverter;
import com.liferay.headless.commerce.delivery.catalog.internal.dto.v1_0.converter.SkuDTOConverterContext;
import com.liferay.headless.commerce.delivery.catalog.internal.resource.v1_0.BaseSkuResourceImpl;
import com.liferay.headless.commerce.delivery.catalog.resource.v1_0.SkuResource;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v1_0/sku.properties"}, scope=ServiceScope.PROTOTYPE, service={NestedFieldSupport.class, SkuResource.class})
public class SkuResourceImpl
extends BaseSkuResourceImpl
implements NestedFieldSupport {
    @Reference
    private CommerceAccountHelper _commerceAccountHelper;
    @Reference
    private CommerceAccountLocalService _commerceAccountLocalService;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceContextFactory _commerceContextFactory;
    @Reference
    private CommerceProductViewPermission _commerceProductViewPermission;
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;
    @Reference
    private SkuDTOConverter _skuDTOConverter;

    @Override
    @NestedField(parentClass=Product.class, value="skus")
    public Page<Sku> getChannelProductSkusPage(Long channelId, @NestedFieldId(value="productId") Long productId, Long accountId, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionLocalService.fetchCPDefinitionByCProductId(productId.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCProductException();
        }
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannel(channelId.longValue());
        int countUserCommerceAccounts = this._commerceAccountHelper.countUserCommerceAccounts(this.contextUser.getUserId(), commerceChannel.getGroupId());
        if (countUserCommerceAccounts > 1) {
            if (accountId == null) {
                throw new NoSuchAccountException();
            }
        } else {
            long[] commerceAccountIds = this._commerceAccountHelper.getUserCommerceAccountIds(this.contextUser.getUserId(), commerceChannel.getGroupId());
            if (commerceAccountIds.length == 0) {
                CommerceAccount commerceAccount = this._commerceAccountLocalService.getGuestCommerceAccount(this.contextUser.getCompanyId());
                commerceAccountIds = new long[]{commerceAccount.getCommerceAccountId()};
            }
            accountId = commerceAccountIds[0];
        }
        this._commerceProductViewPermission.check(PermissionThreadLocal.getPermissionChecker(), accountId.longValue(), commerceChannel.getGroupId(), cpDefinition.getCPDefinitionId());
        List cpInstances = this._cpInstanceLocalService.getCPDefinitionInstances(cpDefinition.getCPDefinitionId(), 0, pagination.getStartPosition(), pagination.getEndPosition(), null);
        int totalItems = this._cpInstanceLocalService.getCPDefinitionInstancesCount(cpDefinition.getCPDefinitionId(), 0);
        return Page.of(this._toSKUs(channelId, accountId, cpInstances, cpDefinition), (Pagination)pagination, (long)totalItems);
    }

    private List<Sku> _toSKUs(Long channelId, Long accountId, List<CPInstance> cpInstances, CPDefinition cpDefinition) throws Exception {
        CommerceContext commerceContext;
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannel(channelId.longValue());
        int countUserCommerceAccounts = this._commerceAccountHelper.countUserCommerceAccounts(this.contextUser.getUserId(), commerceChannel.getGroupId());
        if (countUserCommerceAccounts > 1) {
            if (accountId == null) {
                throw new NoSuchAccountException();
            }
            commerceContext = this._commerceContextFactory.create(this.contextCompany.getCompanyId(), commerceChannel.getGroupId(), this.contextUser.getUserId(), 0L, accountId.longValue());
        } else {
            long[] commerceAccountIds = this._commerceAccountHelper.getUserCommerceAccountIds(this.contextUser.getUserId(), commerceChannel.getGroupId());
            if (commerceAccountIds.length == 0) {
                CommerceAccount commerceAccount = this._commerceAccountLocalService.getGuestCommerceAccount(this.contextUser.getCompanyId());
                commerceAccountIds = new long[]{commerceAccount.getCommerceAccountId()};
            }
            commerceContext = this._commerceContextFactory.create(this.contextCompany.getCompanyId(), commerceChannel.getGroupId(), this.contextUser.getUserId(), 0L, commerceAccountIds[0]);
        }
        ArrayList<Sku> skus = new ArrayList<Sku>();
        for (CPInstance cpInstance : cpInstances) {
            skus.add(this._skuDTOConverter.toDTO((DTOConverterContext)new SkuDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpInstance.getCPInstanceId(), cpDefinition, this.contextCompany.getCompanyId(), commerceContext)));
        }
        return skus;
    }
}

